% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingPatientsNearDose-class}
\alias{StoppingPatientsNearDose-class}
\alias{.StoppingPatientsNearDose}
\alias{StoppingPatientsNearDose}
\alias{.DefaultStoppingPatientsNearDose}
\title{\code{StoppingPatientsNearDose}}
\usage{
StoppingPatientsNearDose(
  nPatients = 10L,
  percentage = 50,
  include_backfill = TRUE,
  report_label = NA_character_
)

.DefaultStoppingPatientsNearDose()
}
\arguments{
\item{nPatients}{(\code{number})\cr see slot definition.}

\item{percentage}{(\code{number})\cr see slot definition.}

\item{include_backfill}{(\code{flag})\cr see slot definition.}

\item{report_label}{(\code{string} or \code{NA})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{StoppingPatientsNearDose}} is the class for stopping based on number of
patients near to next best dose.
}
\section{Slots}{

\describe{
\item{\code{nPatients}}{(\code{number})\cr number of required patients.}

\item{\code{percentage}}{(\code{number})\cr percentage (between and including 0 and 100)
within the next best dose the patients must lie.}

\item{\code{include_backfill}}{(\code{flag})\cr whether to include backfill patients.}
}}

\note{
Typically, end users will not use the \code{.DefaultStoppingPatientsNearDose()} function.
}
\examples{
# As example, here is the rule for stopping the study if at least 9 patients
# were dosed at a dose within (1 +/- 0.2) of the next best dose.

my_stopping <- StoppingPatientsNearDose(
  nPatients = 9,
  percentage = 20
)

# Variant which excludes backfill cohorts.

my_stopping <- StoppingPatientsNearDose(
  nPatients = 9,
  percentage = 20,
  include_backfill = FALSE
)
}
