% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_ma.R
\name{dema}
\alias{dema}
\title{Add Double Exponential Moving Average (DEMA) to the chart}
\usage{
dema(
 price  = "close",
 n      = 10,
 v      = 1,
 wilder = FALSE,
 ratio  = NULL,
 ...
)
}
\arguments{
\item{price}{A \link{character}-vector of \link{length} 1. "close" by default.
The name of the vector to passed into \code{\link[TTR:MovingAverages]{TTR::DEMA()}}.}

\item{n}{Number of periods to average over. Must be between 1 and
\code{nrow(x)}, inclusive.}

\item{v}{The 'volume factor' (a number in [0,1]).  See Notes.}

\item{wilder}{logical; if \code{TRUE}, a Welles Wilder type EMA will be
calculated; see notes.}

\item{ratio}{A smoothing/decay ratio.  \code{ratio} overrides \code{wilder}
in \code{EMA}.}

\item{...}{For internal use. Please ignore.}
}
\value{
A \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:add_trace]{plotly::add_lines()}}-wrapper function that
interacts with \{TTR\}'s moving average family of functions.
The function adds moving average indicators to the main \code{\link[=chart]{chart()}}.
}
\examples{
# script start;

cryptoQuotes::chart(
  ticker = BTC,
  main = kline(),
  indicator = list(
    cryptoQuotes::ema(n = 7),
    cryptoQuotes::sma(n = 14),
    cryptoQuotes::wma(n = 21)
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other moving average indicators: 
\code{\link{alma}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{sma}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other main chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{sma}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{main chart indicators}
\concept{moving average indicators}
