% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fgi.R
\name{get_fgindex}
\alias{get_fgindex}
\title{Get the daily Fear and Greed Index
in the cryptocurrency market}
\usage{
get_fgindex(
 from = NULL,
 to   = NULL
)
}
\arguments{
\item{from}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}

\item{to}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}
}
\value{
An <[\link[xts]{xts}]>-object containing,

\item{index}{<\link{POSIXct}> the time-index}
\item{fgi}{<\link{numeric}> the daily fear and greed index value}

\strong{Sample output}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#>                     fgi
#> 2024-05-12 02:00:00  56
#> 2024-05-13 02:00:00  57
#> 2024-05-14 02:00:00  66
#> 2024-05-15 02:00:00  64
#> 2024-05-16 02:00:00  70
#> 2024-05-17 02:00:00  74
}\if{html}{\out{</div>}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get the daily fear and greed index.
}
\details{
\subsection{Classification}{

The Fear and Greed Index goes from 0-100, and can be classified as follows,

\itemize{
\item 0-24, Extreme Fear
\item 25-44, Fear
\item 45-55, Neutral
\item 56-75, Greed
\item 76-100, Extreme Greed
}
}

\subsection{About the Fear and Greed Index}{

The fear and greed index is a market sentiment indicator that measures
investor emotions to gauge whether they are generally fearful
(indicating potential selling pressure) or
greedy (indicating potential buying enthusiasm).
}

\subsection{Source}{

This index is fetched from
\href{https://alternative.me/crypto/fear-and-greed-index/}{alternative.me},
and can be different from the one provided by
\href{https://coinmarketcap.com/charts/#fear-and-greed-index}{coinmarketcap}.
}
}
\examples{
\dontrun{
  # script start;

  # 1) get the fear and greed index
  # for the last 7 days
  tail(
    fgi <- cryptoQuotes::get_fgindex(
      from = Sys.Date() - 7
    )
  )

  # script end;
}

}
\seealso{
Other get-functions: 
\code{\link{get_fundingrate}()},
\code{\link{get_lsratio}()},
\code{\link{get_openinterest}()},
\code{\link{get_quote}()}
}
\author{
Serkan Korkmaz
}
\concept{get-functions}
