% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.csvy.R
\name{plot_csvy_control}
\alias{plot_csvy_control}
\title{Control settings for plot.csvy}
\usage{
plot_csvy_control(
  x1lab = NULL,
  x1_labels = TRUE,
  x2lab = NULL,
  x2_labels = TRUE,
  x3lab = NULL,
  x3_labels = TRUE,
  x4_vals = NULL,
  x4_labels = NULL,
  ynm = NULL,
  ci = TRUE,
  legend = TRUE,
  ylab = TRUE,
  x1size = 3.8,
  x2size = 3.8,
  constrained_color = "cornflowerblue",
  unconstrained_color = "#A3C99A",
  constrained_shape = 16,
  unconstrained_shape = 18,
  ribbon_fill = "lightblue",
  line_color = "black",
  base_theme = ggplot2::theme_minimal(),
  subtitle.size = 12,
  angle = 0,
  hjust = 0.1
)
}
\arguments{
\item{x1lab}{Character. Label for the first covariate (x-axis). Default is \code{NULL}.}

\item{x1_labels}{Logical or Character vector. Custom tick labels for the first covariate. Default is \code{TRUE}. If it is TRUE, tick labels will be created; if it is a character vector, then this vector will be used as the tick labels.}

\item{x2lab}{Character. Label for the second covariate (x-axis). Default is \code{NULL}.}

\item{x2_labels}{Logical or Character vector. Custom tick labels for the second covariate. Default is \code{TRUE}. Default is \code{TRUE}. If it is TRUE, tick labels will be created; if it is a character vector, then this vector will be used as the tick labels.}

\item{x3lab}{Character. Label for the third covariate, if used (for subtitles or grouping). Default is \code{NULL}.}

\item{x3_labels}{Logical or Character vector. Custom labels for the third covariate. Default is \code{TRUE}. If it is TRUE, labels will be created; if it is a character vector, then this vector will be used as the labels.}

\item{x4_vals}{Character vector. For models with more than three predictors, specifies the category to use for each additional predictor. Defaults to NULL, using the mode of each.}

\item{x4_labels}{Character vector. Custom labels for the fourth covariate. Default is \code{NULL}.}

\item{ynm}{Character. Label for the response. Default is \code{NULL}.}

\item{ci}{Logical. If TRUE, confidence bands are displayed. Defaults to TRUE.}

\item{legend}{Logical. If TRUE, legend for constrained fit or unconstrained fit will be shown. Defaults to TRUE.}

\item{ylab}{Logical. If TRUE, the response name will be shown on the y-axis. Defaults to TRUE.}

\item{x1size}{Numeric. Font size for annotation labels on the x1 axis. Default is \code{3.8}.}

\item{x2size}{Numeric. Font size for annotation labels on the x2 axis. Default is \code{3.8}.}

\item{constrained_color}{Character. Color used to display fitted values and intervals from the constrained model. Default is \code{"cornflowerblue"}.}

\item{unconstrained_color}{Character. Color used to display fitted values and intervals from the unconstrained model. Default is \code{"#A3C99A"}.}

\item{constrained_shape}{Integer. Shape code (used by \code{ggplot2}) for points corresponding to constrained fits. Default is \code{16} (solid circle).}

\item{unconstrained_shape}{Integer. Shape code for points from unconstrained fits. Default is \code{18} (solid diamond).}

\item{ribbon_fill}{Character. Fill color for the confidence ribbon around the fitted lines. Default is \code{"lightblue"}.}

\item{line_color}{Character. Color of the lines connecting the fitted values. Default is \code{"black"}.}

\item{base_theme}{A \code{ggplot2} theme object used as the base plot theme. Default is \code{ggplot2::theme_minimal()}.}

\item{subtitle.size}{Numeric. Font size for the subtitle text in the plot. Default is \code{12}.}

\item{angle}{Numeric. Angle (in degrees) to rotate x-axis labels (typically for x1). Default is \code{0}.}

\item{hjust}{Numeric. Horizontal justification for rotated x-axis labels. Default is \code{.1} (right-aligned).}
}
\value{
A named list of graphical control parameters to be passed to the \code{control} argument in \code{\link{plot.csvy}}.
}
\description{
Creates a list of graphical options to customize plots generated by \code{\link{plot.csvy}}.
This includes labels, text sizes, colors, shapes, themes, and other display features.
}
\examples{
data(nhdat2, package = 'csurvey')
dstrat <- svydesign(ids = ~id, strata = ~str, data = nhdat2, weight = ~wt)
ans <- csvy(chol ~ incr(age), design = dstrat, n.mix=5)
#check the constrained fit vs the unconstrained fit with default aesthetics
ctl <- plot_csvy_control()
plot(ans, type = 'both', control = ctl)
#check the fit with user-defined aethetics
ctl <- list(x1lab = "Age Group", x2lab = "Region", constrained_color = "cornflowerblue", 
unconstrained_color = "gray80", x1size = 4.5)
plot(ans, type = 'both', control = ctl)
}
