% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanPostPredict.R
\name{ctPostPredPlots}
\alias{ctPostPredPlots}
\title{Create diagnostic plots to assess the goodness-of-fit for a ctsem model.}
\usage{
ctPostPredPlots(fit)
}
\arguments{
\item{fit}{A fitted ctsem model.}
}
\value{
a list of ggplot2 plots.
}
\description{
This function generates a set of diagnostic plots to assess the goodness-of-fit for
a fitted ctsem model.
}
\details{
The function calculates various statistics and creates visualizations to evaluate
how well the generated data matches the original data used to fit the model. The plots
included are as follows:
  - A scatter plot comparing observed values and the median of generated data.
  - A plot showing the proportion of observed data outside the 95% confidence interval
  - A density plot of the proportion of observed data greater than the generated data.
  - A time series plot of the proportion of observed data greater than generated data.
}
\examples{
print(ctPostPredPlots(ctstantestfit))

}
