% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{check_existence_by_dtxsid_batch}
\alias{check_existence_by_dtxsid_batch}
\title{Check existence by DTXSID batch}
\usage{
check_existence_by_dtxsid_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSIDs}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request.}

\item{Server}{The root address of the API endpoint}

\item{verbose}{A logical indicating whether some "progress report" should be
given.}
}
\value{
A data.table of information detailing valid and invalid DTXSIDs.
}
\description{
Check existence by DTXSID batch
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
dtxsids <- c('DTXSID7020182F', 'DTXSID7020182', 'DTXSID0020232F')
existence <- check_existence_by_dtxsid_batch(DTXSID = dtxsids)
\dontshow{\}) # examplesIf}
}
