% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs.R
\name{get_aggregate_records_by_medium}
\alias{get_aggregate_records_by_medium}
\title{Get aggregate records by medium}
\usage{
get_aggregate_records_by_medium(
  Medium = NULL,
  API_key = NULL,
  Server = "https://comptox.epa.gov/ctx-api/exposure",
  pageNumber = 1,
  verbose = FALSE
)
}
\arguments{
\item{Medium}{The mmdb medium of exposure.}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{pageNumber}{Parameter for how to return data records.}

\item{verbose}{A logical indicating if some "progress report" should be
given.}
}
\value{
A list of search parameters and data of aggregate record data by
medium.
}
\description{
Get aggregate records by medium
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
#Pull aggregate records for BPA by medium
bpa_agg_records <- get_aggregate_records_by_medium(Medium = 'surface water')
\dontshow{\}) # examplesIf}
}
