% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-guts_red.R
\name{GUTS_RED_SD}
\alias{GUTS_RED_SD}
\alias{GutsRedSd-class}
\alias{GUTS-RED-SD}
\title{GUTS-RED-SD scenario}
\usage{
GUTS_RED_SD(param, init)
}
\arguments{
\item{param}{optional named \code{list} or \code{vector} with model parameters}

\item{init}{optional named numeric \code{vector} to use as initial state}
}
\value{
an S4 object of type \linkS4class{GutsRedSd}
}
\description{
Reduced \emph{General Unified Threshold models of Survival} (GUTS) with stochastic
death (\emph{SD}).
}
\section{Simulation output}{

The return value of \code{\link[=simulate]{simulate()}} will contain values for the state variables,
as well as an additional column \code{S} which represents the survival probability
for each time point. \code{S} is calculated as described in EFSA (2018) as
\emph{S = exp(-H)}. The background hazard rate \code{hb} is already considered in state
variable \code{H} and therefore does not occur as an additional term to derive \code{S}.
}

\section{State variables}{

The following list describes the default names and standard units of \emph{GUTS-RED}
state variables:
\itemize{
\item \code{D}, scaled damage (conc)
\item \code{H}, cumulative hazard (-)
}

The state variables are initialized with zero by default.
}

\section{SD model parameters}{

\itemize{
\item \code{kd}, dominant rate constant (time^-1)
\item \code{hb}, background hazard rate (time^-1)
\item \code{z}, threshold for effects (conc)
\item \code{kk}, killing rate constant (time^-1)
}
}

\section{Effects}{

The effect endpoint \code{L} (lethality) is available for \emph{GUTS-RED} models.
A value of zero (\code{0.0}) denotes \emph{no effect} on organism survival. A value of
one (\code{1.0}) denotes a lethality rate of 100\%, i.e. no survivors.

The survival probability \code{S} is available in the return value of \code{\link[=simulate]{simulate()}}.
}

\section{Solver settings}{

The arguments to ODE solver \code{\link[deSolve:ode]{deSolve::ode()}} control how model equations
are numerically integrated. The settings influence stability of the numerical
integration scheme as well as numerical precision of model outputs. Generally, the
default settings as defined by \emph{deSolve} are used, but all \emph{deSolve} settings
can be modified in \emph{cvasi} workflows by the user, if needed. Please refer
to e.g. \code{\link[=simulate]{simulate()}} on how to pass arguments to \emph{deSolve} in \emph{cvasi}
workflows.
}

\references{
EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, et al., 2018: \emph{Scientific Opinion on the
state of the art of Toxicokinetic/Toxicodynamic (TKTD) effect models for
regulatory risk assessment of pesticides for aquatic organisms}. EFSA Journal 2018;
16(8):5377, 188 pp. \doi{10.2903/j.efsa.2018.5377}
}
\seealso{
Other GUTS-RED models: 
\code{\link{GUTS-RED-models}},
\code{\link{GUTS_RED_IT}()}
}
\concept{GUTS-RED models}
