% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_param.R
\name{get_param}
\alias{get_param}
\alias{get_param,ANY-method}
\alias{get_param,list-method}
\alias{get_param,EffectScenario-method}
\alias{get_param,ScenarioSequence-method}
\alias{get_param,ParameterSet-method}
\title{Get scenario parameters}
\usage{
get_param(x)

\S4method{get_param}{list}(x)

\S4method{get_param}{EffectScenario}(x)

\S4method{get_param}{ScenarioSequence}(x)

\S4method{get_param}{ParameterSet}(x)
}
\arguments{
\item{x}{object to fetch parameters from}
}
\value{
(list of) list(s) with key-value pairs
}
\description{
For scenario \link[=sequence]{sequences}, only the parameters of the first scenario
in the sequence is returned. To access parameters of a specific scenario in
the sequence, use \code{get_param()} on the individual scenario object.
}
\section{Methods (by class)}{
\itemize{
\item \code{get_param(list)}: Returns a list of parameter lists (if applicable)

\item \code{get_param(EffectScenario)}: Returns a list parameters for a single \link{scenario}

\item \code{get_param(ScenarioSequence)}: Returns a list of parameter lists, one for each scenario in the sequence

\item \code{get_param(ParameterSet)}: Returns a list of parameters for a single \link{parameter_set}

}}
\examples{
minnow_it \%>\% get_param()
}
\seealso{
\code{\link[=set_param]{set_param()}}
}
