% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tag.R
\name{get_tag}
\alias{get_tag}
\alias{get_tag,ANY-method}
\alias{get_tag,list-method}
\alias{get_tag,EffectScenario-method}
\alias{get_tag,ScenarioSequence-method}
\alias{get_tag,ParameterSet-method}
\title{Get scenario tag}
\usage{
get_tag(x)

\S4method{get_tag}{list}(x)

\S4method{get_tag}{EffectScenario}(x)

\S4method{get_tag}{ScenarioSequence}(x)

\S4method{get_tag}{ParameterSet}(x)
}
\arguments{
\item{x}{(vector of) \link{scenarios} or \link{parameter_set} objects}
}
\value{
(list of) tag(s), returns \code{NA} if no tag was set
}
\description{
Returns the user-defined, custom tag of a scenario, if available.
Tags can be helpful to quickly distinguish scenarios by e.g. a user-specified
string. The function supports vectorized inputs. If more
than one scenario is supplied in argument \code{x}, then a list of tags is
returned.
}
\section{Methods (by class)}{
\itemize{
\item \code{get_tag(list)}: Returns a list of tags (if applicable)

\item \code{get_tag(EffectScenario)}: Returns the tag of a single \link{scenario}

\item \code{get_tag(ScenarioSequence)}: Returns a list of tags, one for each scenario in the sequence

\item \code{get_tag(ParameterSet)}: Returns the tag of a single \link{parameter_set}

}}
\examples{
# returns `fathead minnow`
get_tag(minnow_it)

# update or set a tag
myscenario <- GUTS_RED_IT() \%>\% set_tag("My Custom Tag")
# returns `My Custom Tag`
get_tag(myscenario)
}
\seealso{
\code{\link[=set_tag]{set_tag()}}
}
