% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_cop_corr.R
\name{fit_cylcop_cor}
\alias{fit_cylcop_cor}
\alias{fit_cylcop_cor,cyl_vonmises-method}
\alias{fit_cylcop_cor,cyl_quadsec-method}
\alias{fit_cylcop_cor,cyl_cubsec-method}
\alias{fit_cylcop_cor,cyl_rot_combine-method}
\alias{fit_cylcop_cor,cyl_rect_combine-method}
\alias{optCor}
\title{Estimate Copula Parameters from Correlation Measures}
\usage{
fit_cylcop_cor(copula, theta, x, acc = NULL, n = 10000, method, ...)

\S4method{fit_cylcop_cor}{cyl_vonmises}(copula, theta, x, acc, n, method = "cor_cyl")

\S4method{fit_cylcop_cor}{cyl_quadsec}(copula, theta, x, acc, n, method = "cor_cyl")

\S4method{fit_cylcop_cor}{cyl_cubsec}(
  copula,
  theta,
  x,
  acc,
  n,
  method = "cor_cyl",
  parameter = "both"
)

\S4method{fit_cylcop_cor}{cyl_rot_combine}(copula, theta, x, acc, n, method = "mi_cyl")

\S4method{fit_cylcop_cor}{cyl_rect_combine}(copula, theta, x, acc, n, method = "tau", background = FALSE)

optCor(copula, theta, x, acc = NULL, n = 10000, method, ...)
}
\arguments{
\item{copula}{\R object of class '\code{\linkS4class{cyl_copula}}'.}

\item{theta}{\link[base]{numeric} \link[base]{vector} of angles
(measurements of a circular variable).}

\item{x}{\link[base]{numeric} \link[base]{vector} of step lengths
(measurements of a linear variable).}

\item{acc}{\link[base]{numeric} value, the interval of the copula parameter
at which to evaluate the correlation.}

\item{n}{\link[base]{numeric} value, the number of sample points at each
optimization step.}

\item{method}{\link[base]{character} string describing what correlation metric
 to use. Either a rank-based circular-linear correlation coefficient (\code{"cor_cyl"}),
mutual information (\code{"mi_cyl"}), or Kendall's tau (\code{"tau"}).}

\item{...}{Additional parameters (see individual methods).}

\item{parameter}{For '\code{\linkS4class{cyl_cubsec}}' copulas: A character
string specifying which parameter of the copula to optimize,
  \code{"a"}, \code{"b"}, or \code{"both"}}

\item{background}{For '\code{\linkS4class{cyl_rect_combine}}' copulas :
A \link[base]{logical} value describing whether to optimize
the parameter of the background copula, (\code{background = TRUE}) or
the one of the copula in the rectangles (\code{background = FALSE}).}
}
\value{
\link[base]{numeric} \link[base]{vector} containing the estimated
parameter value(s).
}
\description{
This function implements a simple search of the parameter space of a
'\code{\linkS4class{cyl_copula}}' object to find the
parameter values that lead to a correlation that is closest to the correlation
in the data (\code{theta} and \code{x}). In some special cases of
'\code{\linkS4class{cyl_rect_combine}}' copulas, the parameter can be
obtained analytically from Kendall's tau of the data.
}
\details{
The code assumes that the correlation captured by the copula increases
monotonously with the copula parameter values. It starts with a parameter value close
to the minimum for that copula and calculates the correlation for a sample of size \code{n}
from that copula. Next, the parameter is doubled and again the correlation for a sample
of size \code{n} calculated. After this exponential search pattern, a binary search
is implemented similarly between the bounds found with the exponential search. For this
binary search, the interval between those bounds is split into small intervals of length
\code{acc}. Thus, smaller values of \code{acc} lead to higher accuracy.

If a '\code{\linkS4class{cyl_rect_combine}}' copula has rectangles spanning
the entire unit square and as background the independence copula, Kendall's tau can be used
to analytically calculate the parameter value leading to the correlation of the data.
No search is necessary in this case. This makes it the recommended method to use
for those '\code{\linkS4class{cyl_rect_combine}}' copulas.
\code{optCor()} is an alias for \code{fit_cylcop_cor}.

See also individual methods (below) for more detailed explanations.
}
\section{Functions}{
\itemize{
\item \code{fit_cylcop_cor(cyl_vonmises)}: only parameter \code{"kappa"} can be optimized, since parameter
\code{"mu"} does not influence the correlation.

\item \code{fit_cylcop_cor(cyl_quadsec)}: the absolute value of the parameter is optimized, positive
and negative values give the same correlation.

\item \code{fit_cylcop_cor(cyl_cubsec)}: optimization of parameters, \code{"a"} and \code{"b"},
can be done separately or simultaneously.

\item \code{fit_cylcop_cor(cyl_rot_combine)}: the circular-linear correlation coefficient will give a
value close to 0 for any parameter value. It therefore only makes sense to
use \code{method = "mi_cyl"} for the optimization.

\item \code{fit_cylcop_cor(cyl_rect_combine)}: if the rectangles span the entire unit square and the background
is the independence copula, it is recommended to use \code{method = "tau"}, since this
calculates the copula parameter analytically. If there is a background copula,
other than the independence copula, its parameter can be optimized by setting
\code{background=TRUE}.

}}
\examples{
set.seed(123)

sample <- rcylcop(100, cyl_rect_combine(copula::frankCopula(2)))
fit_cylcop_cor(cyl_rect_combine(copula::frankCopula()),
  theta = sample[,1],
  x = sample[,2],
  method = "tau"
)

fit_cylcop_cor(cyl_rect_combine(copula::frankCopula()),
  theta = sample[,1],
  x = sample[,2],
  method = "mi_cyl",
  n = 100
)

fit_cylcop_cor(cyl_rect_combine(copula::claytonCopula()),
  theta = sample[,1],
  x = sample[,2],
  method = "tau"
)

fit_cylcop_cor(cyl_quadsec(), theta = sample[,1], x = sample[,2], method = "mi_cyl")
fit_cylcop_cor(cyl_quadsec(), theta = sample[,1], x = sample[,2], method = "cor_cyl")
fit_cylcop_cor(cyl_quadsec(),
  theta = sample[,1],
  x = sample[,2],
  method = "cor_cyl",
  n = 100,
  acc = 0.001
)

optCor(cyl_quadsec(),
 theta = sample[,1],
 x = sample[,2],
 method = "mi_cyl")

}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{\link{mi_cyl}()}, \code{\link{cor_cyl}()}, \code{\link{fit_cylcop_ml}()},
\code{\link{opt_auto}()}, \code{copula::\link[copula]{fitCopula}()}.
}
