% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_cop_scat}
\alias{plot_cop_scat}
\title{Scatterplot of Copula Values}
\usage{
plot_cop_scat(traj = NULL, u = NULL, v = NULL)
}
\arguments{
\item{traj}{a \link[base]{data.frame} containing the trajectory produced by e.g.
\code{\link{traj_sim}()}, which must contain the columns
\code{traj$cop_u} and \code{traj$cop_v}.}

\item{u}{(alternatively) \link[base]{numeric} \link[base]{vector} of first
components of pseudo-observations or draws from a copula.}

\item{v}{(alternatively) \link[base]{numeric} \link[base]{vector} of second
components of pseudo-observations or draws from a copula.}
}
\value{
A '\code{\link[ggplot2]{ggplot}}' object, the scatterplot.
}
\description{
This function produces a scatterplot ('\code{\link[ggplot2]{ggplot}}' object) of
a sample from a copula. Either a sample is provided as input, or a sample
is drawn from a copula to quickly visualize it.
}
\details{
Alternatively, instead of plotting a sample from a copula \code{cop}
using \code{scatterplot(copula=cop)}, you can also use \code{\link{plot}(cop)}.
If a trajectory is provided and \code{n} is smaller than \code{nrow(traj)},
\code{n} steps are randomly selected from the trajectory and plotted.
}
\examples{
set.seed(123)
traj <- traj_sim(100,
  copula = cyl_quadsec(0.1),
  marginal_circ = list(name = "vonmises", coef  = list(0, 1)),
  marginal_lin = list(name = "weibull", coef = list(shape = 3))
)
plot_cop_scat(traj = traj)

sample <- rcylcop(100,cyl_quadsec(0.1))
plot_cop_scat(u = sample[,1], v = sample[,2])

}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{\link{plot_track}()},
\code{\link{plot_joint_circ}()}, \code{\link{plot_cop_surf}()}, \code{\link{plot_joint_scat}()}.
}
