% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{cost_function<-}
\alias{cost_function<-}
\alias{cost_function<-.drift_dm}
\alias{cost_function}
\alias{cost_function.drift_dm}
\alias{cost_function.fits_ids_dm}
\alias{cost_function.fits_agg_dm}
\alias{cost_value}
\alias{cost_value.drift_dm}
\alias{cost_value.fits_ids_dm}
\alias{cost_value.fits_agg_dm}
\title{Access/Replace the Cost Function Label and Access the Cost Function Value}
\usage{
cost_function(object, ...) <- value

\method{cost_function}{drift_dm}(object, ..., eval_model = FALSE) <- value

cost_function(object, ...)

\method{cost_function}{drift_dm}(object, ...)

\method{cost_function}{fits_ids_dm}(object, ...)

\method{cost_function}{fits_agg_dm}(object, ...)

cost_value(object, ...)

\method{cost_value}{drift_dm}(object, ...)

\method{cost_value}{fits_ids_dm}(object, ...)

\method{cost_value}{fits_agg_dm}(object, ...)
}
\arguments{
\item{object}{an object of type \link{drift_dm}, \code{fits_ids_dm}, or
\code{fits_agg_dm} (see \code{\link[=estimate_dm]{estimate_dm()}}).}

\item{...}{additional arguments passed down to \code{\link[=update_stats_agg]{update_stats_agg()}}
when setting the cost function label.}

\item{value}{a character string, providing the cost function label
(options are \code{"neg_log_like"} or \code{"rmse"})}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not when updating the conditions (see \link{re_evaluate_model}).
Default is \code{FALSE}.}
}
\value{
\itemize{
\item \code{cost_function()} returns a single character string, specifying the used
cost function
\item \verb{cost_function<-()} returns the model object with the updated cost
function.
\item \code{cost_value()} returns a single numeric if \code{object} is of type \code{drift_dm}
or \code{fits_agg_dm}. If there is no data attached to an object of type
\code{drift_dm}, the function returns \code{NULL}. If \code{object} is of type
\code{fits_ids_dm}, the function returns a \link{data.frame} with all cost values
across participants.
}
}
\description{
Functions to access/replace the cost function label of a \verb{dRiftDM object} and
to access the current cost function value.
The cost function label codes which cost function is used during estimation
(e.g., the negative log-likelihood). The cost function value indicates the
current value of the cost function given the current set of parameters and
the data.
}
\examples{
# get a pre-built model for demonstration purpose
a_model <- ratcliff_dm(obs_data = ratcliff_synth_data)
cost_function(a_model)
cost_value(a_model)

# switch the default cost function to rmse
cost_function(a_model) <- "rmse"
out <- estimate_dm(a_model, verbose = 0, messaging = FALSE)
# -> the model was estimated using the RMSE statistic


}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}, \code{\link[=re_evaluate_model]{re_evaluate_model()}}
}
