% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_drift_dm.R
\name{summary.drift_dm}
\alias{summary.drift_dm}
\alias{print.summary.drift_dm}
\title{Summary for \code{drift_dm} objects}
\usage{
\method{summary}{drift_dm}(object, ...)

\method{print}{summary.drift_dm}(x, ..., round_digits = drift_dm_default_rounding())
}
\arguments{
\item{object}{an object of class \code{drift_dm}.}

\item{...}{additional arguments passed forward (currently not used).}

\item{x}{an object of class \code{summary.drift_dm}.}

\item{round_digits}{integer, specifying the number of decimal places for
rounding in the printed summary. Default is 3.}
}
\value{
\code{summary.drift_dm()} returns a list of class \code{summary.drift_dm} (see details
for the entries).

\code{print.summary.drift_dm()} returns invisibly the \code{summary.drift_dm} object.
}
\description{
summary and corresponding printing methods for objects of class \code{drift_dm},
created by a call to \code{\link[=drift_dm]{drift_dm()}}.
}
\details{
\code{summary.drift_dm()} constructs a summary list with information about the
\code{drift_dm} object. The returned list has class \code{summary.drift_dm} and can
include the following entries:
\itemize{
\item \strong{class}: Class vector of the \code{drift_dm} object.
\item \strong{summary_flex_prms}: Summary of the \link{flex_prms} object in the
model (see \link{summary.flex_prms}).
\item \strong{prms_solve}: Parameters used for solving the model (see
\link{prms_solve}).
\item \strong{solver}: Solver used for generating model predictions.
\item \strong{b_coding}: Boundary coding for the model (see \link{b_coding}).
\item \strong{obs_data}: Summary table of observed response time data, if available,
by response type (upper/lower boundary). rows correspond to upper first
then lower responses; row names are prefixed by the boundary names from
\code{b_coding}. columns (all lower-case) are: \code{min}, \verb{1st qu.}, \code{median},
\code{mean}, \verb{3rd qu.}, \code{max}, and \code{n}.
\item \strong{cost_function}: Name (or descriptor) of the cost function used during
estimation.
\item \strong{fit_stats}: Fit statistics, if available. we return a named atomic
vector created via \code{unlist(unpack_obj(calc_stats(..., type = "fit_stats")))}.
\item \strong{estimate_info}: Additional information about the estimation procedure.
}

\code{print.summary.drift_dm()} displays this summary in a formatted way.
}
\examples{
# get a pre-built model for demonstration
a_model <- dmc_dm()
sum_obj <- summary(a_model)
print(sum_obj, round_digits = 2)

# more information is provided when we add data to the model
obs_data(a_model) <- dmc_synth_data # (data set comes with dRiftDM)
summary(a_model)

# fit indices are added once we evaluate the model
a_model <- re_evaluate_model(a_model)
summary(a_model)

}
