% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_lstm_ed.R
\name{autoenc_lstm_ed}
\alias{autoenc_lstm_ed}
\title{LSTM Autoencoder - Encode-Decode}
\usage{
autoenc_lstm_ed(
  input_size,
  encoding_size,
  batch_size = 32,
  num_epochs = 50,
  learning_rate = 0.001
)
}
\arguments{
\item{input_size}{Integer. Number of input features per observation.}

\item{encoding_size}{Integer. Size of the latent (bottleneck) representation.}

\item{batch_size}{Integer. Mini-batch size used during training. Default is 32.}

\item{num_epochs}{Integer. Maximum number of training epochs. Default is 50.}

\item{learning_rate}{Numeric. Optimizer learning rate. Default is 0.001.}
}
\value{
A \code{autoenc_lstm_ed} object.
}
\description{
Creates a deep learning LSTM-based autoencoder that encodes and decodes
sequences of observations. Wraps a PyTorch implementation via \code{reticulate}.
}
\examples{
\dontrun{
X <- matrix(rnorm(1000), nrow = 50, ncol = 20)
ae <- autoenc_lstm_ed(input_size = 20, encoding_size = 5, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)
X_hat <- daltoolbox::transform(ae, X)  # reconstructions
mean((X - X_hat)^2)
}

# See:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_lstm_ed.md
}
\references{
Hochreiter, S., & Schmidhuber, J. (1997). Long Short-Term Memory.
}
