% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_geo_radial.R
\docType{data}
\name{coord_geo_radial}
\alias{coord_geo_radial}
\alias{CoordGeoRadial}
\title{Enhanced polar coordinate system with geological timescale}
\usage{
coord_geo_radial(
  dat = "periods",
  theta = "y",
  start = -0.5 * pi,
  end = 1.25 * pi,
  expand = TRUE,
  direction = deprecated(),
  reverse = "none",
  r.axis.inside = NULL,
  rotate.angle = FALSE,
  inner.radius = 0.05,
  fill = NULL,
  alpha = 1,
  lwd = 0.25,
  color = "grey80",
  lty = "solid",
  lab = FALSE,
  abbrv = TRUE,
  skip = c("Quaternary", "Holocene", "Late Pleistocene"),
  neg = TRUE,
  prop = 1,
  textpath_args = list(),
  clip = "off",
  r_axis_inside = deprecated(),
  rotate_angle = deprecated()
)
}
\arguments{
\item{dat}{Either A) a string indicating a built-in dataframe with interval
data from the ICS ("periods", "epochs", "stages", "eons", or "eras"), B) a
string indicating a timescale from macrostrat (see list here:
\url{https://macrostrat.org/api/defs/timescales?all}), or C) a custom
data.frame of time interval boundaries (see Details).}

\item{theta}{The variable to map angle to (\code{x} or \code{y}). This should normally
be \code{y} when using this function with \code{ggtree}.}

\item{start}{Offset of starting point from 12 o'clock in radians. Offset
is applied clockwise or anticlockwise depending on value of \code{direction}.}

\item{end}{Position from 12 o'clock in radians where plot ends, to allow
for partial polar coordinates. The default, \code{NULL}, is set to
\code{start + 2 * pi}.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to prevent overlap between data and axes. If \code{FALSE}, limits
are taken directly from the scale.}

\item{direction}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{reverse}{A string giving which directions to reverse. \code{"none"}
(default) keep directions as is. \code{"theta"} reverses the angle and \code{"r"}
reverses the radius. \code{"thetar"} reverses both the angle and the radius.}

\item{r.axis.inside}{One of the following:
\itemize{
\item \code{NULL} (default) places the axis next to the panel if \code{start} and
\code{end} arguments form a full circle and inside the panel otherwise.
\item \code{TRUE} to place the radius axis inside the panel.
\item \code{FALSE} to place the radius axis next to the panel.
\item A numeric value, setting a theta axis value at which
the axis should be placed inside the panel. Can be given as a length 2
vector to control primary and secondary axis placement separately.
}}

\item{rotate.angle}{If \code{TRUE}, transforms the \code{angle} aesthetic in data
in accordance with the computed \code{theta} position. If \code{FALSE} (default),
no such transformation is performed. Can be useful to rotate text geoms in
alignment with the coordinates.}

\item{inner.radius}{A \code{numeric} between 0 and 1 setting the size of a
inner radius hole.}

\item{fill}{The fill color of the background. The default is to use the
\code{color} column included in \code{dat}. If a custom dataset is provided with
\code{dat} without a \code{color} column and without fill, a greyscale will be used.
Custom fill colors can be provided with this option (overriding the \code{color}
column) and will be recycled if/as necessary.}

\item{alpha}{The transparency of the fill colors.}

\item{lwd}{Line width for lines between intervals. Set to \code{NULL} to remove
lines.}

\item{color}{The color of the lines between intervals.}

\item{lty}{Line type for lines between intervals.}

\item{lab}{Whether to include labels. Requires the \code{geomtextpath} package.}

\item{abbrv}{If including labels, whether to use abbreviations instead of
full interval names.}

\item{skip}{A vector of interval names indicating which intervals should not
be labeled. If \code{abbrv} is \code{TRUE}, this can also include interval
abbreviations.}

\item{neg}{Set this to true if your theta-axis is using negative values. This
is usually true if you are using \code{ggtree}.}

\item{prop}{This is the rotational proportion of the background that the
scale takes up.}

\item{textpath_args}{A list of named arguments to provide to
\code{\link[geomtextpath:geom_textpath]{geomtextpath::geom_textpath()}}. Only used if \code{lab} is set to \code{TRUE}.
Useful arguments include \code{color} (font color), \code{family} (font family),
\code{fontface}, \code{hjust} (radial adjustment), and \code{size} (font size).}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. For details, please see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}.}

\item{r_axis_inside, rotate_angle}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
\code{coord_geo_radial} behaves similarly to \code{\link[ggplot2:coord_radial]{ggplot2::coord_radial()}} in that it
occurs after statistical transformation and will affect the visual appearance
of geoms. The main difference is that it also adds a geological timescale to
the background of the plot. \code{coord_geo_radial} is similar to
\code{\link[=coord_geo_polar]{coord_geo_polar()}} but has more options related to the polar coordinate
plotting that are inherited from \code{\link[ggplot2:coord_radial]{ggplot2::coord_radial()}} (e.g., \code{end},
\code{r_axis_inside}, \code{inner.radius}). Furthermore, unlike \code{coord_geo_polar},
\code{coord_geo_radial} uses the ggplot2 internals to draw the \code{r} and \code{theta}
axes, gridlines, etc. This means that users can tweak the
\link[ggplot2:guides]{guide} and \link[ggplot2:theme]{theme} settings for these
features (see examples).
}
\details{
If a custom data.frame is provided (with \code{dat}), it should consist of at
least 2 columns of data. See \code{data(periods)} for an example.
\itemize{
\item The \code{max_age} column lists the oldest boundary of each time interval.
\item The \code{min_age} column lists the youngest boundary of each time
interval.
\item The \code{abbr} column is optional and lists abbreviations that may be
used as labels.
\item The \code{color} column is optional and lists a \link[ggplot2:aes_colour_fill_alpha]{color}
for the background for each time interval.
}

\code{dat} may also be a list of values and/or dataframes if multiple time scales
should be added to the background. Scales will be added sequentially starting
at \code{start} and going in the specified \code{direction}. By default the scales will
all be equal in circular/rotational proportion, but this can be overridden
with \code{prop}. If \code{dat} is a list, \code{fill}, \code{alpha}, \code{lwd}, \code{color}, \code{lty},
\code{lab}, \code{abbrv}, \code{skip}, \code{neg}, \code{prop}, and \code{textpath_args} can also be lists
(N.B. \code{textpath_args} would be a list of lists). If these lists are not as
long as \code{dat}, the elements will be recycled. If individual values (or
vectors) are used for these parameters, they will be applied to all time
scales (and recycled as necessary).

If the sum of the \code{prop} values is greater than 1, the proportions will be
scaled such that they sum to 1. However, the \code{prop} values may sum to less
than 1 if the user would like blank space in the background.

Care must be taken when adding labels to plots, as they are very likely to
overlap with the plot under the default settings. The \code{textpath_args}
argument can be used to adjust the settings for the plotting of the labels.
See \code{\link[geomtextpath:geom_textpath]{geomtextpath::geom_textpath()}} for details about the available
arguments. Also note that the curvature of the labels may vary based on the
distance from the origin. This is why \code{abbrv} is set to \code{TRUE} by default.
}
\examples{
library(ggplot2)
\dontshow{if (require(ggtree)) withAutoprint(\{ # examplesIf}
library(ggtree)
set.seed(1)
tree <- rtree(100)
# single scale
revts(ggtree(tree)) +
  coord_geo_radial(dat = "stages") +
  scale_y_continuous(guide = "none", breaks = NULL) +
  theme_gray()

# multiple scales
revts(ggtree(tree)) +
  coord_geo_radial(
    dat = list("stages", "periods"), alpha = .5,
    prop = list(0.75, .25), start = pi / 4, end = 2 * pi, lty = "dashed"
  ) +
  scale_y_continuous(expand = expansion(mult = c(0.02, 0.02)),
                     guide = "none", breaks = NULL) +
  theme_gray()
\dontshow{\}) # examplesIf}
\dontshow{if (require(ggtree) && require(paleotree)) withAutoprint(\{ # examplesIf}
library(ggplot2)
library(paleotree)
data(RaiaCopesRule)
ggtree(ceratopsianTreeRaia,
       position = position_nudge(x = -ceratopsianTreeRaia$root.time)) +
  coord_geo_radial(dat = "stages") +
  scale_y_continuous(guide = "none", breaks = NULL) +
  theme_classic()
\dontshow{\}) # examplesIf}
}
\keyword{datasets}
