% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{aniso}
\alias{aniso}
\title{Fitting anisotropic spatial Gaussian process models}
\usage{
aniso(x, z, n, correlation = FALSE, cosine = FALSE, standardise = "together")
}
\arguments{
\item{x}{a 2-column matrix comprising x and y coordinates column-wise, respectively, or a list; see Details for the latter}

\item{z}{a variance-covariance matrix}

\item{n}{an integer number of data}

\item{correlation}{a logical defining whether \code{z} should be assumed to be a correlation matrix; defaults to \code{FALSE}}

\item{cosine}{a logical defining whether the powered exponential covariance function should be multiplied by the cosine of scaled distances, i.e. giving a damped oscillation; defaults to \code{FALSE}}

\item{standardise}{a character string that governs whether dimensions are scaled by a common (\code{"together"}) or dimension-specific factor; defaults to \code{"together"}}
}
\value{
An object of class \code{deform} and then of class \code{anisotropic}
}
\description{
Function \code{aniso} fits a conventional 2-dimensional anisotropic Gaussian 
process, i.e. just with scalings in the x and y coordinates.
}
\details{
If \code{x} is a list, then it wants elements \code{"x"}, \code{"z"} and \code{"n"} as described above.
}
\examples{

data(solar)
aniso(solar$x, solar$z, solar$n) 
# equivalent to aniso(solar)

}
\references{
Sampson, P. D. and Guttorp, P. (1992) Nonparametric Estimation of Nonstationary Spatial
Covariance Structure, Journal of the American Statistical Association, 87:417, 108-119,
\doi{10.1080/01621459.1992.10475181}'
}
