% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_others.R
\name{collapse_others}
\alias{collapse_others}
\title{Summarise Haplotype Metadata Down to One Row}
\usage{
collapse_others(data, hap_tbl, labels, cols)
}
\arguments{
\item{data}{An object of class \link[tibble:tbl_df-class]{tbl_df} containing sequence metadata.}

\item{hap_tbl}{Output from \link{haplotype_tbl}.}

\item{labels}{Column name which contains sequence names.}

\item{cols}{A character vector of variables to collapse.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\description{
\code{collapse_others()} returns a \link[tibble:tbl_df-class]{tbl_df} summarising
all unique haplotype frequencies, duplicates and selected metadata into a single row.
}
\details{
\code{collapse_others()} is a helper function to summarise metadata along with
\link{haplotype_tbl}. For any given \code{cols}, \code{collapse_others()} flattens its content
by unique haplotypes and its duplicates in \code{hap_tbl}.
}
\examples{
# summarise haplotypes
hap_tbl <- haplotype_tbl(geophagus)

# summarise country
others_df <- collapse_others(geophagus_info, hap_tbl, "gbAccession", "country")

}
\author{
Pedro S. Bittencourt, Rupert A. Collins.
}
