% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmd.R
\name{hmd}
\alias{hmd}
\alias{hmd.mx}
\alias{hmd.e0}
\alias{hmd.pop}
\title{Read data from HMD and construct a mortality demogdata object}
\usage{
hmd.mx(country, username, password, label = country)

hmd.e0(country, username, password)

hmd.pop(country, username, password, label = country)
}
\arguments{
\item{country}{Directory abbreviation from the HMD. For instance, Australia =
"AUS".}

\item{username}{HMD username (case-sensitive)}

\item{password}{HMD password (case-sensitive)}

\item{label}{Character string giving name of country from which the data are
taken.}
}
\value{
\code{hmd.mx} returns an object of class \code{demogdata} with the following components:
\item{year}{Vector of years}
\item{age}{Vector of ages}
\item{rate}{A list containing one or more rate matrices with one age group per row and one column per year.}
\item{pop}{A list of the same form as \code{rate} but containing population numbers instead of demographic rates.}
\item{type}{Type of object: \dQuote{mortality}, \dQuote{fertility} or \dQuote{migration}.}
\item{label}{label}
\code{hmd.pop} returns a similar object but without the \code{rate} component.
\code{hmd.e0} returns an object of class \code{ts} with columns \code{male}, \code{female} and \code{total}.
}
\description{
\code{hmd.mx} reads "Mx" (1x1) data from the Human Mortality Database (HMD
\url{https://www.mortality.org}) and constructs a demogdata object suitable
for plotting using \code{\link{plot.demogdata}} and fitting an LC or BMS
model using \code{\link{lca}} or an FDA model using \code{\link{fdm}}.
\code{hmd.pop} reads "Population" (1x1) data from the HMD and constructs a
demogdata object suitable for plotting using \code{\link{plot.demogdata}}.
\code{hmd.e0} reads life expectancy at birth from the HMD and returns the
result as a \code{ts} object.
}
\details{
In order to read the data, users are required to create their account via the HMD website (\url{https://www.mortality.org}),
and obtain a valid username and password.
}
\examples{
\dontrun{
norway <- hmd.mx("NOR", username, password, "Norway")
summary(norway)
}
}
\seealso{
\code{\link{demogdata}},\code{\link{read.demogdata}},\code{\link{plot.demogdata}}, \code{\link{life.expectancy}}
}
\author{
Rob J Hyndman
}
\keyword{manip}
