% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wald_test_nb.r
\name{wald_test_nb}
\alias{wald_test_nb}
\title{Wald test for NB ratio of means}
\usage{
wald_test_nb(
  data,
  equal_dispersion = FALSE,
  ci_level = NULL,
  link = "log",
  ratio_null = 1,
  distribution = asymptotic(),
  ...
)
}
\arguments{
\item{data}{(list)\cr
A list whose first element is the vector of negative binomial values
from group 1 and the second element is the vector of negative binomial
values from group 2.
\link[base]{NA}s are silently excluded. The default output from
\code{\link[=sim_nb]{sim_nb()}}.}

\item{equal_dispersion}{(Scalar logical: \code{FALSE})\cr
If \code{TRUE}, the Wald test is calculated assuming both groups have the
same population dispersion parameter. If \code{FALSE} (default), the Wald
test is calculated assuming different dispersions.}

\item{ci_level}{(Scalar numeric: \code{NULL}; \verb{(0, 1)})\cr
If \code{NULL}, confidence intervals are set as \code{NA}. If in \verb{(0, 1)},
confidence intervals are calculated at the specified level.}

\item{link}{(Scalar string: \code{"log"})\cr
The one-to-one link function for transformation of the ratio in the
test hypotheses. Must be one of \code{"log"} (default), \code{"sqrt"},
\code{"squared"}, or \code{"identity"}. See 'Details' for additional information.}

\item{ratio_null}{(Scalar numeric: \code{1}; \verb{(0, Inf)})\cr
The (pre-transformation) ratio of means assumed under the null
hypothesis (group 2 / group 1). Typically \code{ratio_null = 1}
(no difference). See 'Details' for additional information.}

\item{distribution}{(function: \code{\link[=asymptotic]{asymptotic()}} or
\code{\link[=simulated]{simulated()}})\cr
The method used to define the distribution of the \eqn{\chi^2} Wald
test statistic under the null hypothesis. See 'Details' and
\code{\link[=asymptotic]{asymptotic()}} or \code{\link[=simulated]{simulated()}} for additional
information.}

\item{...}{Optional arguments passed to the MLE function \code{\link[=mle_nb]{mle_nb()}}.}
}
\value{
A list with the following elements:
\tabular{llll}{
Slot \tab Subslot \tab Name \tab Description \cr
1 \tab \tab \code{chisq} \tab \eqn{\chi^2} test statistic for the ratio of means. \cr
2 \tab \tab \code{df}    \tab Degrees of freedom. \cr
3 \tab \tab \code{p}     \tab p-value. \cr

4 \tab \tab \code{ratio}      \tab Estimated ratio of means (group 2 / group 1). \cr
4 \tab 1 \tab \code{estimate} \tab Point estimate. \cr
4 \tab 2 \tab \code{lower}    \tab Confidence interval lower bound. \cr
4 \tab 3 \tab \code{upper}    \tab Confidence interval upper bound. \cr

5 \tab \tab \code{mean1} \tab Estimated mean of group 1. \cr
6 \tab \tab \code{mean2} \tab Estimated mean of group 2. \cr
7 \tab \tab \code{dispersion1} \tab Estimated dispersion of group 1. \cr
8 \tab \tab \code{dispersion2} \tab Estimated dispersion of group 2. \cr
9  \tab \tab \code{n1} \tab Sample size of group 1. \cr
10 \tab \tab \code{n2} \tab Sample size of group 2. \cr
11 \tab \tab \code{method} \tab Method used for the results. \cr
12 \tab \tab \code{ci_level} \tab The confidence level. \cr
13 \tab \tab \code{equal_dispersion} \tab Whether or not equal dispersions were assumed. \cr
14 \tab \tab \code{link} \tab Link function used to transform the ratio of means in the test hypotheses. \cr
15 \tab \tab \code{ratio_null} \tab Assumed ratio of means under the null hypothesis. \cr
16 \tab \tab \code{mle_code} \tab Integer indicating why the optimization process terminated. \cr
17 \tab \tab \code{mle_message} \tab Information from the optimizer.
}
}
\description{
Wald test for the ratio of means from two independent negative binomial
outcomes.
}
\details{
This function is primarily designed for speed in simulation. Missing values
are silently excluded.

Suppose \eqn{X_1 \sim NB(\mu, \theta_1)} and
\eqn{X_2 \sim NB(r\mu, \theta_2)} where \eqn{X_1} and \eqn{X_2} are
independent, \eqn{X_1} is the count outcome for items in group 1, \eqn{X_2}
is the count outcome for items in group 2, \eqn{\mu} is the arithmetic mean
count in group 1, \eqn{r} is the ratio of arithmetic means for group 2 with
respect to group 1, \eqn{\theta_1} is the dispersion parameter of group 1,
and \eqn{\theta_2} is the dispersion parameter of group 2.

The hypotheses for the Wald test of \eqn{r} are

\deqn{
\begin{aligned}
H_{null} &: f(r) = f(r_{null}) \\
H_{alt} &: f(r) \neq f(r_{null})
\end{aligned}
}

where \eqn{f(\cdot)} is a one-to-one link function with nonzero derivative,
\eqn{r = \frac{\bar{X}_2}{\bar{X}_1}} is the population ratio of arithmetic
means for group 2 with respect to group 1, and \eqn{r_{null}} is a constant
for the assumed null population ratio of means (typically \eqn{r_{null} = 1}).

\insertCite{rettiganti_2012;textual}{depower} found that \eqn{f(r) = r^2} and
\eqn{f(r) = r} had greatest power when \eqn{r < 1}. However, when
\eqn{r > 1}, \eqn{f(r) = \ln r}, the likelihood ratio test, and the Rao score
test have greatest power. Note that \eqn{f(r) = \ln r}, LRT, and RST were
unbiased tests while the \eqn{f(r) = r} and \eqn{f(r) = r^2} tests were
biased when \eqn{r > 1}. The \eqn{f(r) = \ln r}, LRT, and RST produced
acceptable results for any \eqn{r} value. These results depend on the use of
asymptotic vs. exact critical values.

The Wald test statistic is

\deqn{
W(f(\hat{r})) = \left( \frac{f \left( \frac{\bar{x}_2}{\bar{x}_1} \right) - f(r_{null})}{f^{\prime}(\hat{r}) \hat{\sigma}_{\hat{r}}} \right)^2
}

where

\deqn{
\hat{\sigma}^{2}_{\hat{r}} = \frac{\hat{r} \left[ n_1 \hat{\theta}_1 (\hat{r} \hat{\mu} + \hat{\theta}_2) + n_2 \hat{\theta}_2 \hat{r} (\hat{\mu} + \hat{\theta}_1) \right]}{n_1 n_2 \hat{\theta}_1 \hat{\theta}_2 \hat{\mu}}
}

Under \eqn{H_{null}}, the Wald test statistic is asymptotically distributed
as \eqn{\chi^2_1}. The approximate level \eqn{\alpha} test rejects
\eqn{H_{null}} if \eqn{W(f(\hat{r})) \geq \chi^2_1(1 - \alpha)}. However,
the asymptotic critical value is known to underestimate the exact critical
value and the nominal significance level may not be achieved for small sample
sizes. The level of significance inflation also depends on \eqn{f(\cdot)} and
is most severe for \eqn{f(r) = r^2} where only the exact critical value
should be used. Argument \code{distribution} allows control of the distribution of
the \eqn{\chi^2_1} test statistic under the null hypothesis by use of
functions \code{\link[=asymptotic]{asymptotic()}} and \code{\link[=simulated]{simulated()}}.

Note that standalone use of this function with \code{equal_dispersion = FALSE}
and \code{distribution = simulated()}, e.g.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data |>
  wald_test_nb(
    equal_dispersion = FALSE,
    distribution = simulated()
  )
}\if{html}{\out{</div>}}

results in a nonparametric randomization test based on label permutation.
This violates the assumption of exchangeability for the randomization test
because the labels are not exchangeable when the null hypothesis assumes
unequal dispersions. However, used inside \code{\link[=power]{power()}}, e.g.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data |>
  power(
    wald_test_nb(
      equal_dispersion = FALSE,
      distribution = simulated()
    )
  )
}\if{html}{\out{</div>}}

results in parametric resampling and no label permutation in performed.
Thus, setting \code{equal_dispersion = FALSE} and \code{distribution = simulated()} is
only recommended when \code{\link[=wald_test_nb]{wald_test_nb()}} is used inside of
\code{\link[=power]{power()}}. See also, \code{\link[=simulated]{simulated()}}.
}
\examples{
#----------------------------------------------------------------------------
# wald_test_nb() examples
#----------------------------------------------------------------------------
library(depower)

set.seed(1234)
sim_nb(
  n1 = 60,
  n2 = 40,
  mean1 = 10,
  ratio = 1.5,
  dispersion1 = 2,
  dispersion2 = 8
) |>
  wald_test_nb()

}
\references{
\insertRef{rettiganti_2012}{depower}

\insertRef{aban_2009}{depower}
}
\seealso{
\code{\link[=lrt_nb]{lrt_nb()}}
}
