% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Erlang.R
\name{Erlang}
\alias{Erlang}
\title{Create an Erlang distribution}
\usage{
Erlang(k, lambda)
}
\arguments{
\item{k}{The shape parameter. Can be any positive integer number.}

\item{lambda}{The rate parameter. Can be any positive number.}
}
\value{
An \code{Erlang} object.
}
\description{
The Erlang distribution is a two-parameter family of continuous probability
distributions with support \eqn{x \in [0,\infty)}.
The two parameters are a positive integer shape parameter \eqn{k} and a
positive real rate parameter \eqn{\lambda}.
The Erlang distribution with shape parameter \eqn{k = 1} simplifies to the
exponential distribution, and it is a special case of the gamma distribution.
It corresponds to a sum of \eqn{k} independent exponential variables with mean
\eqn{1 / \lambda} each.
}
\examples{

set.seed(27)

X <- Erlang(5, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
\seealso{
Other continuous distributions: 
\code{\link{Beta}()},
\code{\link{Cauchy}()},
\code{\link{ChiSquare}()},
\code{\link{Exponential}()},
\code{\link{FisherF}()},
\code{\link{Frechet}()},
\code{\link{GEV}()},
\code{\link{GP}()},
\code{\link{Gamma}()},
\code{\link{Gumbel}()},
\code{\link{LogNormal}()},
\code{\link{Logistic}()},
\code{\link{Normal}()},
\code{\link{RevWeibull}()},
\code{\link{StudentsT}()},
\code{\link{Tukey}()},
\code{\link{Uniform}()},
\code{\link{Weibull}()}
}
\concept{continuous distributions}
