% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowmap.R
\name{dodgr_flowmap}
\alias{dodgr_flowmap}
\title{Create a map of \code{dodgr} flows.}
\usage{
dodgr_flowmap(net, bbox = NULL, linescale = 1)
}
\arguments{
\item{net}{A street network with a \code{flow} column obtained from
\link{dodgr_flows_aggregate} or \link{dodgr_flows_disperse}}

\item{bbox}{If given, scale the map to this bbox, otherwise use entire extend
of \code{net}}

\item{linescale}{Maximal thickness of plotted lines}
}
\value{
Nothing; called for side-effect of producing plot.
}
\description{
Create a map of the output of \link{dodgr_flows_aggregate} or
\link{dodgr_flows_disperse}
}
\note{
\code{net} should be first passed through \code{merge_directed_graph}
prior to plotting, otherwise lines for different directions will be overlaid.
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 10)
to <- sample (graph$to_id, size = 5)
to <- to [!to \%in\% from]
flows <- matrix (
    10 * runif (length (from) * length (to)),
    nrow = length (from)
)
graph <- dodgr_flows_aggregate (graph, from = from, to = to, flows = flows)
# graph then has an additonal 'flows` column of aggregate flows along all
# edges. These flows are directed, and can be aggregated to equivalent
# undirected flows on an equivalent undirected graph with:
graph_undir <- merge_directed_graph (graph)
\dontrun{
dodgr_flowmap (graph_undir)
}
}
\seealso{
Other misc: 
\code{\link{compare_heaps}()},
\code{\link{dodgr_full_cycles}()},
\code{\link{dodgr_fundamental_cycles}()},
\code{\link{dodgr_insert_vertex}()},
\code{\link{dodgr_sample}()},
\code{\link{dodgr_sflines_to_poly}()},
\code{\link{dodgr_vertices}()},
\code{\link{merge_directed_graph}()},
\code{\link{summary.dodgr_dists_categorical}()},
\code{\link{write_dodgr_wt_profile}()}
}
\concept{misc}
