% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominanceBriefing.r
\name{dominanceBriefing}
\alias{dominanceBriefing}
\title{Retrieve a briefing for complete, conditional and general dominance}
\usage{
dominanceBriefing(da.object, fit.functions = NULL, abbrev = FALSE)
}
\arguments{
\item{da.object}{a \code{dominanceAnalysis} object}

\item{fit.functions}{name of the fit indices to retrieve. If NULL, all fit indices will be retrieved}

\item{abbrev}{if TRUE}
}
\value{
a list. Each element is a data.frame, that comprises the dominance analysis
        for a specific fit index. Each data.frame have the predictors as row
        and each column reports the predictors that are dominated for each predictor
}
\description{
Retrieve a briefing for complete, conditional and general dominance
}
\examples{
# For matrix or data.frame
data(longley)
da.longley<-dominanceAnalysis(lm(Employed~.,longley))
dominanceBriefing(da.longley, abbrev=FALSE)
dominanceBriefing(da.longley, abbrev=TRUE)
}
\seealso{
Other retrieval methods: 
\code{\link{averageContribution}()},
\code{\link{contributionByLevel}()},
\code{\link{dominanceMatrix}()},
\code{\link{getFits}()}
}
\concept{retrieval methods}
