% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.wrda.R
\name{predict.wrda}
\alias{predict.wrda}
\title{Prediction from cca0 and wrda models}
\usage{
\method{predict}{wrda}(
  object,
  ...,
  type = c("response", "lc"),
  rank = "full",
  newdata = NULL,
  weights = NULL,
  scaling = "symmetric"
)
}
\arguments{
\item{object}{return value of \code{\link{cca0}} or \code{\link{wrda}}.}

\item{...}{Other arguments passed to the function (currently ignored).}

\item{type}{type of prediction, \code{c(
"response", "lc")} for 
response (expected abundance) and constrained scores for sites.}

\item{rank}{rank (number of axes to use). Default "full" for all axes 
(no rank-reduction).}

\item{newdata}{Data in which to look for variables with which to predict.}

\item{weights}{list of weights of species and of sites in \code{newdata} 
when \code{type = "response"}, else ignored (default NULL
yielding equal species and site weights, both summing to 1). 
Example: weights = list(species = c(100, 1, 1), sites = c(1, 1, 1, 1)), in 
that order, with traits of three new species in newdata[[1]] and 
environmental values (and levels of factors) of four new sites in 
newdata[[2]]. Species weights are scaled to a sum of one.}

\item{scaling}{numeric (1,2 or 3) or character \code{"sites", "species" or
"symmetric"}. Default: "symmetric". Either site- (1) or species- (2) related
scores are scaled by eigenvalues, and the other set of scores have
unit weighted mean square or with 3 both are scaled symmetrically 
to weighted mean squares equal to the square root of eigenvalues. Negative 
values are treated as the corresponding positive ones by \code{abs(scaling)}.}
}
\value{
a matrix with the predictions. The exact content of the matrix 
depends on the \code{type} of predictions that are being made.
}
\description{
Prediction of response and lc scores from environment data
using \code{\link{cca0}} and \code{\link{wrda}} models.
}
\details{
Variables that are in the model but not in \code{newdata} are set to their 
weighted means in the training data. Predictions are thus at the (weighted)
mean of the quantitative variables not included. Predictions with 
not-included factors are at the reference level (the first level of the 
factor).

In a \code{\link{cca0}} model with \code{type = "response"},
many of the predicted values may be negative,
indicating expected absences (0) or small expected response values.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites
abun <- dune_trait_env$comm[, -1]  # must delete "Sites"

mod <- cca0(formula = abun ~ A1 + Moist + Mag + Use + Manure,
            data = dune_trait_env$envir)

mod # Proportions equal to those Canoco 5.15

scores(mod, which_cor = c("A1", "X_lot"), display = "cor")

set.seed(123)
anova(mod)
anova(mod, by = "axis")

mod2 <- vegan::cca(abun ~ A1 + Moist + Mag + Use + Manure,
                   data = dune_trait_env$envir)
anova(mod2, by = "axis")

dat <- dune_trait_env$envir
dat$Mag <- "SF"
predict(mod, type = "lc", newdata = dat)
}
