% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{buildIgphyml}
\alias{buildIgphyml}
\title{Wrapper to build IgPhyML trees and infer intermediate nodes}
\usage{
buildIgphyml(
  clone,
  igphyml,
  trees = NULL,
  nproc = 1,
  temp_path = NULL,
  id = NULL,
  rseed = NULL,
  quiet = 0,
  rm_files = TRUE,
  rm_dir = NULL,
  partition = c("single", "cf", "hl", "hlf", "hlc", "hlcf"),
  omega = NULL,
  optimize = "lr",
  motifs = "FCH",
  hotness = "e,e,e,e,e,e",
  rates = NULL,
  asrc = 0.95,
  splitfreqs = FALSE,
  asrp = FALSE,
  make_gyrep = TRUE,
  ...
)
}
\arguments{
\item{clone}{list of \code{airrClone} objects}

\item{igphyml}{igphyml executable}

\item{trees}{list of tree topologies if desired}

\item{nproc}{number of cores for parallelization}

\item{temp_path}{path to temporary directory}

\item{id}{IgPhyML run id}

\item{rseed}{random number seed if desired}

\item{quiet}{amount of rubbish to print}

\item{rm_files}{remove temporary files?}

\item{rm_dir}{remove temporary directory?}

\item{partition}{How to partition omegas along sequences (see details)}

\item{omega}{omega parameters to estimate (see IgPhyML docs)}

\item{optimize}{optimize HLP rates (r), lengths (l), topology (t)}

\item{motifs}{motifs to consider (see IgPhyML docs)}

\item{hotness}{hotness parameters to estimate (see IgPhyML docs)}

\item{rates}{comma delimited list showing which omega-defined partitions
get a separate rate (e.g. omega=e,e rates=0,1).}

\item{asrc}{Intermediate sequence cutoff probability}

\item{splitfreqs}{Calculate codon frequencies on each partition separately?}

\item{asrp}{Run ASRp?}

\item{make_gyrep}{Create the grep file?}

\item{...}{Additional arguments (not currently used)}
}
\value{
\code{phylo} object created by igphyml with nodes attribute
         containing reconstructed sequences.
}
\description{
Wrapper to build IgPhyML trees and infer intermediate nodes
}
\details{
Partition options in rate order:
\itemize{
  \item  \code{single}: 1 omega for whole sequence
  \item  \code{cf}: 2 omegas, 1 for all CDRs and 1 for all FWRs
  \item  \code{hl}: 2 omegas, 1 for heavy and 1 for light chain
  \item  \code{hlf}: 3 omegas, 1 for heavy FWR, 1 for all CDRs, and 1 for light FWRs
  \item  \code{hlc}: 3 omegas, 1 for all FWRs, 1 for heavy CDRs, and 1 for light CDRs
  \item  \code{hlcf}: 4 omegas, 1 for each heavy FWR, 1 for heavy CDR, 1 for light FWR, and 1 for light CDR
}
}
