% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round.R
\name{round_pct}
\alias{round_pct}
\title{Rounded percentage}
\usage{
round_pct(x, digits = 1L, method = c("round", "round_sum"))
}
\arguments{
\item{x}{A numeric vector of non-negative values for which you want
percentages to be determined and rounded. Missing values (\code{NA}) are
ignored.}

\item{digits}{The number of decimal places to round to. Default is \code{0}
(integer rounding).}

\item{method}{Rounding method: \code{"round"} that uses R's base \code{\link[=round]{round()}} or
\code{"round_sum"} that uses \link[=round_sum]{dtlg::round_sum}.}
}
\value{
A numeric vector of the same length as \code{x} with rounded percentages.
}
\description{
\code{\link[=round_pct]{round_pct()}} returns the rounded percentages of \code{x} values.
}
\examples{
x <- c(1 / 3, 1 / 3, 1 / 3)

# Default method ensures precise rounding but total might not be 100\%.
round_pct(x = x)
sum(round_pct(x = x))

# You can trade off rounding precision for precision on the total with the
# method `"round_sum"`.
round_pct(x = x, method = "round_sum")
sum(round_pct(x = x, method = "round_sum"))

# Vary the number of decimal places, e.g. increase to three.
round_pct(x = x, digits = 3, method = "round_sum")

# Missing values are ignored.
x <- c(1, 2, NA)
round_pct(x = x, digits = 3)

}
