% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{setdiff.trackr_df}
\alias{setdiff.trackr_df}
\title{Set operations}
\usage{
\method{setdiff}{trackr_df}(
  x,
  y,
  ...,
  .messages = "{.count.out} items in difference",
  .headline = "Difference"
)

\method{setdiff}{trackr_df}(
  x,
  y,
  ...,
  .messages = "{.count.out} items in difference",
  .headline = "Difference"
)
}
\arguments{
\item{x, y}{Vectors to combine.}

\item{...}{a collection of tracked data frames to combine
  Named arguments passed on to \code{\link[tidyr:nest]{tidyr::nest}}\describe{
    \item{\code{.data}}{A data frame.}
\item{\code{.by}}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to nest \emph{by}; these
will remain in the outer data frame.

\code{.by} can be used in place of or in conjunction with columns supplied
through \code{...}.

If not supplied, then \code{.by} is derived as all columns \emph{not} selected by
\code{...}.}
\item{\code{.key}}{The name of the resulting nested column. Only applicable when
\code{...} isn't specified, i.e. in the case of \code{df \%>\% nest(.by = x)}.

If \code{NULL}, then \code{"data"} will be used by default.}
\item{\code{.names_sep}}{If \code{NULL}, the default, the inner names will come from
the former outer names. If a string, the  new inner names will use the
outer names with \code{names_sep} automatically stripped. This makes
\code{names_sep} roughly symmetric between nesting and unnesting.}
}}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, or \{.count.out\}}

\item{.headline}{a glue spec. The glue code can use any global variable, or
\{.count.out\}}
}
\value{
the dplyr output with the history graph updated.
}
\description{
These perform set operations on tracked dataframes. It merges the history
of 2 (or more) dataframes and combines the rows (or columns). It calculates the total number of
resulting rows as \{.count.out\} in other terms it performs exactly the same
operation as the equivalent \code{dplyr} operation. See \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}},
\code{\link[dplyr:bind_cols]{dplyr::bind_cols()}}, \code{\link[dplyr:setops]{dplyr::intersect()}}, \code{\link[dplyr:setops]{dplyr::union()}},
\code{\link[dplyr:setops]{dplyr::setdiff()}},\code{\link[dplyr:setops]{dplyr::intersect()}}, or \code{\link[dplyr:setops]{dplyr::union_all()}} for the
underlying function details.
}
\examples{
library(dplyr)
library(dtrackr)

# Set operations
people = starwars \%>\% select(-films, -vehicles, -starships)
chrs = people \%>\% track("start")

lhs = chrs \%>\% include_any(
  species == "Human" ~ "{.included} humans",
  species == "Droid" ~ "{.included} droids"
)

# these are different subsets of the same data
rhs = chrs \%>\% include_any(
  species == "Human" ~ "{.included} humans",
  species == "Gungan" ~ "{.included} gungans"
) \%>\% comment("{.count} gungans & humans")


# Unions
set = bind_rows(lhs,rhs) \%>\% comment("{.count} 2*human,droids and gungans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()

set = union(lhs,rhs) \%>\% comment("{.count} human,droids and gungans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()

set = union_all(lhs,rhs) \%>\% comment("{.count} 2*human,droids and gungans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()

# Intersections and differences

set = setdiff(lhs,rhs) \%>\% comment("{.count} droids and gungans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()

set = intersect(lhs,rhs) \%>\% comment("{.count} humans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()
}
\seealso{
\code{\link[dplyr:setops]{dplyr::setdiff()}}
}
