% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_cluster_graph.R
\name{add_cluster_graph}
\alias{add_cluster_graph}
\title{Constructs a trajectory using a cell grouping and a network between groups. Will use an existing grouping if it is present in the dataset.}
\usage{
add_cluster_graph(
  dataset,
  milestone_network,
  grouping = NULL,
  explicit_splits = FALSE,
  ...
)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{milestone_network}{A network of milestones.}

\item{grouping}{A grouping of the cells, can be a named vector or a dataframe with \emph{group_id} and \emph{cell_id}}

\item{explicit_splits}{Whether to make splits specific by adding a starting node. For example: A->B, A->C becomes A->X, X->B, X->C}

\item{...}{extra information to be stored in the wrapper.}
}
\value{
A trajectory object
}
\description{
A trajectory in this form will rarely be useful, given that cells are only placed at the milestones themselves, but not on the edges between milestones. A better alternative might be to project the cells using a dimensionality reduction, see \code{\link[=add_dimred_projection]{add_dimred_projection()}}.
}
\examples{
library(tibble)
dataset <- wrap_data(cell_ids = letters)

milestone_network <- tibble::tibble(
  from = c("A", "B", "B"),
  to = c("B", "C", "D"),
  directed = TRUE,
  length = 1
)
milestone_network
grouping <- sample(c("A", "B", "C", "D"), length(dataset$cell_ids), replace = TRUE)
grouping
trajectory <- add_cluster_graph(dataset, milestone_network, grouping)

# for plotting the result, install dynplot
#- dynplot::plot_graph(trajectory)
}
\keyword{create_trajectory}
