% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_PCR.R
\name{read_indexing_PCR}
\alias{read_indexing_PCR}
\alias{read_step1_PCR}
\title{Read Indexing PCR Spreadsheet}
\usage{
read_indexing_PCR(ss)

read_step1_PCR(ss, trim = TRUE, name = TRUE)
}
\arguments{
\item{ss}{Google Sheet ID or URL of the indexing PCR spreadsheet.}

\item{trim}{Logical. If TRUE, removes rows where `Sample` is NA (default: TRUE).}

\item{name}{Logical. If TRUE, adds the spreadsheet name as a `PCR` column in the sample sheet (default: TRUE).}
}
\value{
A tibble with columns:
\describe{
  \item{Well}{Well position}
  \item{Sample}{Sample name}
  \item{Barcode}{Barcode assigned to the sample}
  \item{Set}{Barcode set identifier}
}

A named list with three elements:
\describe{
  \item{PCR_mix}{tibble of reagents and volumes.}
  \item{Cycling}{tibble of PCR cycling conditions.}
  \item{Samples}{tibble of samples with columns `Well`, `Sample`, `Success`, `Notes`, and optionally `PCR`.}
}
}
\description{
Reads data from a Google Sheets-based indexing PCR template. 
You can access the template 
\href{https://docs.google.com/spreadsheets/d/1JdnvURK12fPN4lcm3HcVDPQ3kiL6TsOszLzgSx0c_Tw/edit?usp=sharing}{here},
create a copy in your Google Drive, and then create copies for each of your multiplexing PCR experiments.

Reads data from a Google Sheets-based PCR template.  
You can access the template 
\href{https://docs.google.com/spreadsheets/d/1LBsuUBL2Jx83zz3yIZ2LYGFEmzx0jtPP0T_oG2XW5CQ/edit?usp=sharing}{here}, 
create your own copy, and then create one copy per PCR reaction you want to keep track of.
}
\details{
The function extracts sample information across all plates and returns a tidy dataframe.

Captures reagent mix, cycling conditions, and sample information.
}
\examples{
# Examples are not executed because the function requires identification in Google 
\dontrun{
data("Index_PCR")
read_indexing_PCR(Index_PCR)
}

# Examples are not executed because the function requires identification in Google 
\dontrun{
data("template_PCR")
read_step1_PCR(template_PCR)
}

}
\seealso{
[read_step1_PCR()] for reading normal PCR spreadsheets.

[read_indexing_PCR()] for reading multiplexing PCR spreadsheets.
}
