% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eFCM.R
\name{fcm}
\alias{fcm}
\title{Fit the exponential Factor Copula Model (eFCM)}
\usage{
fcm(
  s,
  object,
  theta0 = c(2, 100),
  thres = 0.9,
  nu = 0.5,
  hessian = TRUE,
  control = list(),
  censorL = TRUE,
  boot = FALSE,
  R = 1000,
  progress = TRUE,
  lower = c(1, 1),
  upper = Inf,
  sample_prop = 0.9,
  sample_ids = NULL,
  parallel = FALSE,
  ncpus = 4,
  mc.set.seed = TRUE,
  ...
)
}
\arguments{
\item{s}{A single integer specifying the grid point index.}

\item{object}{An object of class \code{"fdata"}, typically created by \code{\link[=fdata]{fdata()}}.}

\item{theta0}{A numeric vector of initial values for the copula parameters (\eqn{\lambda, \delta}).}

\item{thres}{A numeric scalar indicating the quantile-based threshold (default is 0.9).}

\item{nu}{Numeric Matérn smoothness parameter.}

\item{hessian}{Logical; whether to return the Hessian matrix. Default is TRUE.}

\item{control}{A list of control options for \code{nlminb()}.}

\item{censorL}{Logical; if TRUE (default), uses the censored likelihood.}

\item{boot}{Logical; whether to perform bootstrap estimation (default \code{FALSE}).}

\item{R}{Integer; number of bootstrap replicates if \code{boot = TRUE}.}

\item{progress}{Logical; if \code{TRUE} (default), show a progress bar during bootstrap
using \pkg{pbapply}.}

\item{lower, upper}{Numeric vectors of parameter bounds for optimization.}

\item{sample_prop}{Numeric in (0,1). Proportion of rows to sample in each replicate
(default 0.9). Ignored if \code{sample_ids} is provided.}

\item{sample_ids}{Optional list of integer vectors. Each element specifies the row indices
to use for a bootstrap replicate; when supplied, overrides \code{sample_prop}.}

\item{parallel}{Logical; if \code{TRUE}, run neighbourhood selection in parallel using \pkg{pbmcapply}.
On Windows, \code{pbmclapply} will fall back to serial execution (progress still shown).}

\item{ncpus}{Integer; number of worker processes when \code{parallel = TRUE} on Unix-alikes.}

\item{mc.set.seed}{Logical; seed the RNG streams in workers (default \code{TRUE}).
Effective on Unix-alikes; on Windows (serial fallback) it has no effect.}

\item{...}{Additional arguments passed to \code{bootstrap_fcm()}.}
}
\value{
An object of class \code{"fcm"}, which is a list including:
\item{pars}{Estimated parameters.}
\item{hessian}{Hessian matrix (if requested).}
\item{nllh}{Negative log-likelihood.}
\item{data.u}{Pseudo-uniform transformed data.}
\item{gridID}{Location of the selected grid point.}
\item{arg}{Model arguments (e.g., \code{thres}, \code{nu}).}
\item{neigh}{Neighbourhood indices used for estimation.}
\item{coord}{Coordinates of the locations.}
\item{data}{Observed data matrix at selected locations.}
\item{boot}{(optional) Matrix of bootstrap samples of parameter estimates.}
}
\description{
Fits the eFCM at a specified grid point using local neighborhood data.
}
\details{
The exponential Factor Copula Model (eFCM) assumes that the process \eqn{W(s) = Z(s) + V}, where \eqn{Z(s)} is a zero-mean Gaussian process with correlation \eqn{\rho(h) = \exp(-h/\delta)} and \eqn{V \sim \mathrm{Exp}(\lambda)} is a latent common factor independent of \eqn{Z(s)} and \eqn{s}. This leads to nontrivial tail dependence between spatial locations.
}
\examples{
\donttest{
# Load precipitation data for counterfactual scenarios
data("counterfactual")
data("LonLat")
coord = LonLat  # station coordinates (longitude-latitude)

cf_data <- fdata(counterfactual, coord, cellsize = c(1, 1))
fit = fcm(s = 1, cf_data, boot = T, R = 1000)
}

}
\references{
Castro-Camilo, D. and Huser, R. (2020). Local likelihood estimation of complex tail dependence structures, applied to US precipitation extremes. \emph{JASA}, 115(531), 1037–1054.
}
\seealso{
\code{\link{fdata}}, \code{\link{coef}}, \code{\link{summary}}
}
