% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pfcm}
\alias{pfcm}
\alias{dfcm}
\alias{qfcm}
\alias{rfcm}
\title{The Distribution of Univariate Factor Copula Model}
\usage{
pfcm(w, lambda)

dfcm(w, lambda)

qfcm(u, lambda, tol = 1e-08, niter = 1000L)

rfcm(n, lambda)
}
\arguments{
\item{w}{A numeric value representing the spatial process.}

\item{lambda}{A numeric value representing rate parameter \eqn{\lambda}.}

\item{u}{a numeric vector of probabilities, with values in the interval from 0 to 1, at which the quantile function is to be computed.}

\item{tol}{a scalar indicating the desired level of numerical accuracy for the algorithm; default is 1e-9.}

\item{niter}{a scalar indicating the maximum number of iterations.}

\item{n}{an integer value specifying the number of samples to generate}
}
\value{
\code{dfcm} gives a numeric value representing the density of the factor copula model evaluated at \code{w},
\code{pfcm} gives a numeric value representing the CDF evaluated at \code{w},
\code{qfcm} gives the quantile function (QF) of the factor copula model.
and \code{rfcm} generate a numeric vector of random samples drawn.
}
\description{
Density, distribution function, quantile function and random generation
for the distribution of univariate factor copula model with rate parameter
equal to \code{lambda}.
}
\details{
The univariate eFCM distribution is \deqn{F(w;\lambda)=\Phi(w)-exp(\lambda^2/2-\lambda w)\Phi(w-\lambda),}
where \eqn{\lambda} is the rate parameter.
}
\examples{
pfcm(w = 1, lambda = 0.5)
dfcm(w = 1, lambda = 0.5)
qfcm(u = 0.5, lambda = 0.5)
rfcm(n = 1000, lambda = 0.5)

}
