% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_dem_aggregate}
\alias{ec_dem_aggregate}
\title{Aggregate posterior draws of demand}
\usage{
ec_dem_aggregate(de,groupby)
}
\arguments{
\item{de}{demand draws}

\item{groupby}{groupby grouping variables (as (vector of) string(s))}
}
\value{
Aggregated demand predictions
}
\description{
Aggregate demand draws, e.g. from individual-choice occasion-alternative level to individual level.
(using the new demand draw format)
}
\examples{
\donttest{
data(icecream)
#run MCMC sampler (use way more than 50 draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<10) \%>\% vd_est_vdm(R=4, keep=1, cores=2)
#Generate demand predictions
icecream_predicted_demand=
 icecream \%>\% dplyr::filter(id<10) \%>\%   
   vd_dem_vdm(icecream_est)
#aggregate
brand_lvl_pred_demand <-
 icecream_predicted_demand \%>\% ec_dem_aggregate("Brand")
}

}
