% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-AddOnlyOrderedMap.R
\name{AddOnlyOrderedMap}
\alias{AddOnlyOrderedMap}
\title{Create an \code{AddOnlyOrderedMap} instance}
\usage{
AddOnlyOrderedMap(
  keys = NULL,
  values = NULL,
  key_validator = Negate(is.null),
  val_validator = Negate(is.null)
)
}
\arguments{
\item{keys}{Optional list. A vector of keys to initialize the map with. Can
be any R object. It is assumed that all keys are unique, otherwise the
behaviour is undefined. This CANNOT be a scalar value. If that is desired,
wrap it in a \code{\link[=list]{list()}}.}

\item{values}{Optional list. An iterable vector of values corresponding to
the keys. This CANNOT be a scalar value. If that is desired, wrap it in a
\code{\link[=list]{list()}}.}

\item{key_validator}{Optional function. A function that validates
\emph{individual} keys before insertion, returning TRUE if valid, FALSE otherwise.}

\item{val_validator}{Optional function. A function that validates
\emph{individual} values before insertion, returning TRUE if valid, FALSE
otherwise.}
}
\value{
An \code{AddOnlyOrderedMap} instance
}
\description{
This function initializes a new list-like object using the
specified keys and values if provided. The resulting map preserves the
order of insertion and does not allow modification or removal of existing
entries.

The \code{AddOnlyOrderedMap} can be interacted with exactly like a regular
list, possessing methods for \code{[}, \code{[[}, \verb{[<-}, and \verb{[[<-} with the same
behaviour, except that NULL cannot be passed in since removal is not
permitted.

The \code{keys()} generic is defined for this class, which will return a list
of the keys in their insertion order. The \code{has_key()} generic is also defined
for this class, returning TRUE/FALSE if a key exists. Lastly, the \code{values()}
generic is defined to get all values in insertion order.
}
\details{
The average time complexity of all operations are linear with respect to
the number of insertion/query inputs, in contrast to R lists which has
quadratic time complexity for the same operations.
}
\keyword{internal}
