% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-claude-tools.R
\name{claude_tool_web_search}
\alias{claude_tool_web_search}
\title{Claude web search tool}
\usage{
claude_tool_web_search(
  max_uses = NULL,
  allowed_domains = NULL,
  blocked_domains = NULL,
  user_location = NULL
)
}
\arguments{
\item{max_uses}{Integer. Maximum number of searches allowed per request.}

\item{allowed_domains}{Character vector. Restrict searches to specific domains
(e.g., \code{c("nytimes.com", "bbc.com")}). Cannot be used with \code{blocked_domains}.}

\item{blocked_domains}{Character vector. Exclude specific domains from searches.
Cannot be used with \code{allowed_domains}.}

\item{user_location}{List with optional elements: \code{country} (2-letter code),
\code{city}, \code{region}, and \code{timezone} (IANA timezone) to localize search results.}
}
\description{
Enables Claude to search the web for up-to-date information. Your organization
administrator must enable web search in the Anthropic Console before using
this tool, as it costs extra ($10 per 1,000 tokens at time of writing).

Learn more in \url{https://docs.claude.com/en/docs/agents-and-tools/tool-use/web-search-tool}.
}
\examples{
\dontrun{
chat <- chat_claude()
chat$register_tool(claude_tool_web_search())
chat$chat("What was in the news today?")
chat$chat("What's the biggest news in the economy?")
}
}
\seealso{
Other built-in tools: 
\code{\link{claude_tool_web_fetch}()},
\code{\link{google_tool_web_fetch}()},
\code{\link{google_tool_web_search}()},
\code{\link{openai_tool_web_search}()}
}
\concept{built-in tools}
