% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{calculate_weighted_metrics}
\alias{calculate_weighted_metrics}
\title{Calculate Weighted Metrics for Energy Burden Analysis}
\usage{
calculate_weighted_metrics(
  graph_data,
  group_columns,
  metric_name,
  metric_cutoff_level,
  upper_quantile_view = 1,
  lower_quantile_view = 0
)
}
\arguments{
\item{graph_data}{A data frame containing household energy burden data with
columns for the metric of interest, household counts, and optional grouping
variables}

\item{group_columns}{Character vector of column names to group by, or NULL
for no grouping (calculates overall statistics)}

\item{metric_name}{Character string specifying the column name of the metric
to analyze (e.g., "ner" for Net Energy Return)}

\item{metric_cutoff_level}{Numeric value defining the poverty threshold for
the metric (e.g., 15.67 for Nh corresponding to 6\% energy burden)}

\item{upper_quantile_view}{Numeric between 0 and 1 specifying the upper
quantile to calculate (default: 1.0 for maximum)}

\item{lower_quantile_view}{Numeric between 0 and 1 specifying the lower
quantile to calculate (default: 0.0 for minimum)}
}
\value{
A data frame with one row per group (or one row if ungrouped)
containing:
\item{household_count}{Total number of households in the group}
\item{households_below_cutoff}{Number of households below poverty threshold}
\item{pct_in_group_below_cutoff}{Proportion of group below threshold}
\item{metric_mean}{Weighted mean of the metric}
\item{metric_median}{Weighted median of the metric}
\item{metric_upper}{Upper quantile value}
\item{metric_lower}{Lower quantile value}
\item{metric_max}{Maximum value in group}
\item{metric_min}{Minimum value in group}
}
\description{
Calculates weighted statistical metrics (mean, median, quantiles) for a
specified energy metric, with optional grouping by geographic or demographic
categories. This is the primary function for aggregating household-level
energy burden data using proper weighting by household counts.
}
\details{
This function requires the \code{spatstat} package for weighted quantile
calculations. It automatically handles missing values and ensures that
statistics are only calculated when sufficient data points exist (n >= 3).

The function adds an "All" category row that aggregates across all groups,
in addition to the individual group statistics.
}
\examples{
\donttest{
# Calculate metrics for NC cooperatives using Nh
library(dplyr)

# Sample data
data <- data.frame(
  cooperative = rep(c("Coop A", "Coop B"), each = 3),
  ner = c(20, 15, 25, 18, 22, 12),
  households = c(1000, 500, 750, 900, 600, 400)
)

# Calculate weighted metrics by cooperative
results <- calculate_weighted_metrics(
  graph_data = data,
  group_columns = "cooperative",
  metric_name = "ner",
  metric_cutoff_level = 15.67,
  upper_quantile_view = 0.95,
  lower_quantile_view = 0.05
)
}
}
