% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_utils.R
\name{validate_before_caching}
\alias{validate_before_caching}
\title{Validate data before caching to database}
\usage{
validate_before_caching(
  data,
  dataset,
  vintage,
  expected_states = 51,
  strict = TRUE
)
}
\arguments{
\item{data}{Data frame to validate}

\item{dataset}{Character, "ami" or "fpl"}

\item{vintage}{Character, "2018" or "2022"}

\item{expected_states}{Integer, expected number of states (51 for nationwide)}

\item{strict}{Logical, if TRUE throws errors; if FALSE returns list with validation results}
}
\value{
If strict=FALSE, returns list with: valid (logical), issues (character vector)
If strict=TRUE, throws error on validation failure
}
\description{
Performs comprehensive validation BEFORE data is saved to database or cache.
Prevents corrupted data from being cached in the first place.
}
\keyword{internal}
