% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humanscape.R
\name{humanscape}
\alias{humanscape}
\title{Compute Energy Landscapes for Walking People}
\usage{
humanscape(dem, m, v = 1.39, unit = "joule", neigh = 8)
}
\arguments{
\item{dem}{raster file of the digital elevation model, either a raster or a
full path location of the file.}

\item{m}{species body mass (kg).}

\item{v}{walking speed (m/s).}

\item{unit}{if joules ('joule') or kilocalories ('kcal').}

\item{neigh}{number of neighbor cells that are connected together.}
}
\value{
EnergyScape raster.
}
\description{
This is the main function to compute energy landscapes from a digital
elevation model, body mass of a person, and walking speed from Looney 
et al. (2019).
}
\examples{
library(terra)
library(enerscape)

data("volcano")
dem <- rast(volcano)
en <- humanscape(dem, 10, 1, unit = "kcal", neigh = 16)
}
\references{
Looney, D. P., Santee, W. R., Hansen, E. O., Bonventre, P. J., Chalmers, C. R., & Potter, A. W. (2019).
Estimating energy expenditure during level, uphill, and downhill walking.
Med. Sci. Sports Exerc., 51(9), 1954-1960. \doi{https://doi.org/10.1249/MSS.0000000000002002}.
}
