% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_ireport_monthly_avgs}
\alias{epitrax_ireport_monthly_avgs}
\title{Create monthly averages internal report from an EpiTrax object}
\usage{
epitrax_ireport_monthly_avgs(epitrax, exclude.report.year = FALSE)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{exclude.report.year}{Logical indicating whether to exclude the current
report year from the report. Defaults to FALSE.}
}
\value{
Updated EpiTrax object with monthly averages report added to the
\code{internal_reports} field.
}
\description{
\code{epitrax_ireport_monthly_avgs} generates an internal report of monthly
averages for all years in the EpiTrax object data, with the option to exclude
the current report year.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_ireport_monthly_avgs()

names(epitrax$internal_reports)
}
