% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_set_report_diseases}
\alias{epitrax_set_report_diseases}
\title{Set report diseases in EpiTrax object}
\usage{
epitrax_set_report_diseases(epitrax, disease_list_files = NULL)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{disease_list_files}{Optional list containing filepaths to internal and
public report disease lists. If omitted, the default lists will be used and
a warning will be given.}
}
\value{
Updated EpiTrax object with \code{report_diseases} field set.
}
\description{
\code{epitrax_set_report_diseases} reads internal and public disease lists and
adds them to the EpiTrax object.
}
\examples{
i_file <- system.file("tinytest/test_files/disease_lists/internal_list.csv",
                       package = "epitraxr")
p_file <- system.file("tinytest/test_files/disease_lists/public_list.csv",
                       package = "epitraxr")

epitrax <- structure(
  list(data = c(1,2,3)),
  class = "epitrax"
)

epitrax <- epitrax_set_report_diseases(
  epitrax,
  disease_list_files = list(
    internal = i_file,
    public = p_file
  )
)
}
\seealso{
\code{\link[=setup_epitrax]{setup_epitrax()}} the convenience function which wraps this function
}
