% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disease_transformation.R
\name{disease_transformation}
\alias{disease_transformation}
\title{Nested functions for a user-defined transformation of a population affected
by a disease outbreak.}
\usage{
disease_transformation(params)
}
\arguments{
\item{params}{A list of parameters, which must contain all of the below,
except \code{name}, which is optional:
\describe{
\item{\code{replicates}}{Number of replicate simulation runs.}
\item{\code{time_steps}}{Number of simulation time steps.}
\item{\code{years_per_step}}{Number of years per time step.}
\item{\code{populations}}{Number of populations.}
\item{\code{seasons}}{Number of seasons per year.}
\item{\code{stages}}{Number of life cycle stages.}
\item{\code{compartments}}{Number of disease compartments (e.g., 3 for a
SIR model).}
\item{\code{demographic_stochasticity}}{Boolean for optionally choosing
demographic stochasticity for the transformation.}
\item{\code{density_stages}}{Array of booleans or numeric (0,1) for each
stage to indicate which stages are affected by density.}
\item{\code{abundance_threshold}}{A quasi-extinction threshold at
which a population becomes extinct.}
\item{\code{mortality}}{A vector of mortality rates, one for each
combination of stages and compartments.}
\item{\code{mortality_unit}}{A vector indicating whether mortality rates
are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{fecundity}}{A vector of fecundity rates, one for each
combination of stages and compartments for which fecundity applies.}
\item{\code{fecundity_unit}}{A vector indicating whether fecundity rates
are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{fecundity_mask}}{A vector indicating which stages and
compartments reproduce.}
\item{\code{transmission}}{A vector of transmission rates, one for each
combination of stages and compartment for which transmission applies (see
\code{transmission_mask} below.}
\item{\code{transmission_unit}}{A vector indicating whether mortality
rates are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{transmission_mask}}{A vector indicating which stages and
compartments are subject to transmission (i.e., classes susceptible to
infection.)}
\item{\code{recovery}}{A vector of recovery rates, one for each
combination of stages and compartment for which recovery applies (see
\code{recovery_mask} below.)}
\item{\code{recovery_unit}}{A vector indicating whether mortality rates
are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{recovery_mask}}{A vector indicating which compartments are
subject to recovery (i.e., infected classes that can recover.)}
\item{\code{transformation}}{A user-defined function (optionally nested in a list
with additional attributes) for performing transformation using \code{params} as
arguments.}
\item{\code{simulator}}{\code{\link[poems:SimulatorReference]{poems::SimulatorReference}} object with
dynamically accessible \emph{attached} and \emph{results} lists.}
\item{\code{name}}{Optional name for the transformation function.}
\item{\code{additional attributes}}{Additional attributes when the
transformation is optionally nested in a list.}
}}
}
\value{
Abundance (and capacity) transformation function:
\code{function(r, tm, carrying_capacity, segment_abundance,
occupied_indices)}, where:
\describe{
\item{\code{r}}{Simulation replicate.}
\item{\code{tm}}{Simulation time step.}
\item{\code{carrying_capacity}}{Array of carrying capacity values for
each population at time step.}
\item{\code{segment_abundance}}{Matrix of abundance for each
stage-compartment combo (rows) and population (columns) at time step.}
\item{\code{occupied_indices}}{Array of indices for populations occupied
at time step.}
\item{\code{returns}}{List with transformed stage abundance matrix (and
optionally carrying capacity).}
}
}
\description{
Modular functions for the disease simulator for performing a transformation
of a population across stages and disease compartments (and optionally
carrying capacity) at a specified time step via a user-defined function.
}
