% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R, R/simulations.R
\name{recommended_dose}
\alias{recommended_dose}
\alias{recommended_dose.simulations}
\title{Recommended dose for next patient or cohort.}
\usage{
recommended_dose(x, ...)

\method{recommended_dose}{simulations}(x, dose_string = FALSE, ...)
}
\arguments{
\item{x}{Object of type \code{\link{selector}}.}

\item{...}{Extra args are passed onwards.}

\item{dose_string}{TRUE to return vector of character dose-strings; FALSE
(the default) to get a numerical vector of recommended dose-indices in
monotherapy studies, or a matrix of recommended dose-indices in combination
studies with the different treatments in columns and simulated outcomes in
rows.}
}
\value{
integer
}
\description{
Get the dose recommended for the next patient or cohort in a dose-finding
trial.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
model <- get_dfcrm(skeleton = skeleton, target = target)
fit <- model \%>\% fit('1NNN 2NTN')
fit \%>\% recommended_dose()
}
