% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_text}
\alias{send_text}
\title{Send a plain text message}
\usage{
send_text(
  client,
  number,
  text,
  delay = NULL,
  link_preview = NULL,
  mentions_everyone = NULL,
  mentioned = NULL,
  quoted = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient in E.164 format (e.g., \code{"+5581999..."}).}

\item{text}{Character. Message body.}

\item{delay}{Integer (ms). Optional presence delay before sending.}

\item{link_preview}{Logical. Enable URL link preview.}

\item{mentions_everyone}{Logical. Mention everyone (if applicable).}

\item{mentioned}{Character vector of JIDs to mention (e.g., \code{jid("+55...")}).}

\item{quoted}{Optional list with Baileys message \code{key} and \code{message} (reply-to).}

\item{verbose}{Logical. If TRUE, logs request/response details with \code{cli} and enables \code{req_verbose()}.}
}
\value{
A named list parsed from the JSON response returned by Evolution API,
containing message metadata (IDs, timestamps, queue information) and any
additional fields defined by the endpoint.
The HTTP status code is stored in \code{attr(result, "http_status")}.
This output represents the API confirmation that the text message was processed.
}
\description{
Sends a plain text WhatsApp message using Evolution API v2.
}
\examples{
\dontrun{
client <- evo_client("https://evolution_api_host", Sys.getenv("EVO_APIKEY"), "chatArgus")
send_text(client, "+55819...", "Ola", delay = 123, link_preview = FALSE, verbose = TRUE)
}
}
