% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proptest_num.R
\name{proptest_num}
\alias{proptest_num}
\alias{prop_binomtest_num}
\alias{nbinomtest}
\title{Proportion Tests}
\usage{
proptest_num(..., arglist = NULL)

prop_binomtest_num(..., arglist = NULL)

nbinomtest(..., arglist = NULL)
}
\arguments{
\item{...}{named input parameters}

\item{arglist}{list: named input parameters, if given \code{...} will be ignored}
}
\value{
A list with the input parameters and the following:
\itemize{
\item \code{X} distribution of the random sampling function
\item \code{Statistic} distribution of the test statistics
\item \code{statistic} test value
\item \code{critical} critical value(s)
\item \code{criticalx} critical value(s) in x range
\item \code{acceptance0} acceptance interval for H0
\item \code{acceptance0x} acceptance interval for H0 in x range
\item \code{accept1} is H1 accepted?
\item \code{p.value} p value for test (note: the p-value may not be reliable see Notes!)
\item \code{alphaexact} exact significance level
\item \code{stderr} standard error of the proportion used as denominator
}
}
\description{
Computes all results for test on proportion using either \code{\link[stats:binom.test]{stats::binom.test()}}, or
a normal approximation without continuity correction.
Either named parameters can be given or an \code{arglist} with the following parameters:
\itemize{
\item \code{x} number of successes
\item \code{n} sample size (default: \code{sd(x)})
\item \code{pi0} true value of the proportion (default: \code{0.5})
\item \code{alternative} a string specifying the alternative hypothesis (default: \code{"two.sided"}), otherwise \code{"greater"} or \code{"less"} can be used
\item \code{alpha} significance level (default: \code{0.05})
\item \code{binom2norm} can the binomial distribution be approximated by a normal distribution? (default: \code{NA} = use \code{binom2norm} function)
}
}
\details{
The results of \code{proptest_num} may differ from \code{\link[stats:binom.test]{stats::binom.test()}}. \code{proptest_num} is designed to return results
when you compute a binomial test by hand. For example, for computing the test statistic the approximation \eqn{t_n \approx N(0; 1)}
is used if \eqn{n>n.tapprox}. The \code{p.value} is computed by \link[stats:binom.test]{stats::binom.test} and may not be reliable, for Details see Note!
}
\note{
The computation of a p-value for non-symmetric distribution is not well defined, see \url{https://stats.stackexchange.com/questions/140107/p-value-in-a-two-tail-test-with-asymmetric-null-distribution}.
}
\examples{
n <- 100
x <- sum(runif(n)<0.4)
proptest_num(x=x, n=n)
}
