% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_to.R
\name{scale_to}
\alias{scale_to}
\title{Rescaling}
\usage{
scale_to(x, mean = 0, sd = 1)
}
\arguments{
\item{x}{numeric: vector of values}

\item{mean}{numeric: mean of the rescaled \code{x} (default: \code{0})}

\item{sd}{numeric: standard deviation of the transformed \code{x} (default: \code{1})}
}
\value{
Rescaled data.
}
\description{
Rescales \code{x} such that for the rescaled data it holds: \code{mean(scale_to(x, mean=target))==target} and
\code{sd(scale_to(x, sd=target)==abs(target)}. A negative value of \code{sd} will change the sign of the \code{x} values.
}
\examples{
x <- runif(50)
y <- scale_to(x, mean=0.1, sd=0.2)
mean(y)
sd(y)
y <- scale_to(x, mean=0.1, sd=-0.2)
mean(y)
sd(y)
}
