% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial.R
\name{toLatex.polynomial}
\alias{toLatex.polynomial}
\title{LaTeX Representation of a Polynomial}
\usage{
\method{toLatex}{polynomial}(
  object,
  digits = TRUE,
  decreasing = FALSE,
  variable = "x",
  simplify = TRUE,
  tol = 1e-09,
  ...
)
}
\arguments{
\item{object}{polynomial}

\item{digits}{numeric or logical: how to convert to text (default: \code{NA})}

\item{decreasing}{logical:  order of the terms by increasing or decreasing powers (default:  \code{FALSE})}

\item{variable}{character: name of variable used (default: \code{"x"})}

\item{simplify}{logical: should the polynomial representation be simplified (default: \code{TRUE})}

\item{tol}{numeric: tolerance (default: \code{1e-9}). A negative value will keep zeros and ones too, but:
\itemize{
\item If a coefficient is smaller than \code{tol} then zero terms are not kept
\item If a absolute value of coefficient minus one is smaller than \code{tol} then coefficient is not kept
}}

\item{...}{unused parameters}
}
\value{
A character
}
\description{
Returns a LaTeX representation of the polynomial.
}
\examples{
p <- polynomial(c(-1,0,2)/3)
toLatex(p, 4)
toLatex(p, FALSE)
toLatex(p, TRUE)
toLatex(p, variable="z")
toLatex(p, decreasing=TRUE)
p <- polynomial(c(0,1,2)/3)
toLatex(p)
toLatex(p, tol=-1)
}
