% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{qc}
\alias{qc}
\alias{qe}
\title{Create vector of characters from unquoted strings (variable names)}
\usage{
qc(...)

qe(...)
}
\arguments{
\item{...}{unquoted names of variables in
\code{qc} or unquoted expressions in \code{qe}.}
}
\value{
Vector of characters or expressions
}
\description{
\itemize{
\item \code{qc} It is often needed to address variables in the data.frame in the such 
manner: \code{dfs[ , c("var1", "var2", "var3")]}. \code{qc} ("quoted c") is a
shortcut for the such cases to reduce keystrokes. With \code{qc} you can write:
\code{dfs[ , qc(var1, var2, var3)]}.
\item \code{qe} returns list of expression.}
}
\examples{

## qc
qc(a, b, c)
identical(qc(a, b, c), c("a", "b", "c"))

mtcars[, qc(am, mpg, gear)]

## qe
qe(mrset(a1 \%to\% a6), mrset(b1 \%to\% b6), mrset(c1 \%to\% c6))
}
