% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radf-autoplot.R
\name{autoplot.ds_radf}
\alias{autoplot.ds_radf}
\title{Plotting a \code{ds_radf} object}
\usage{
\method{autoplot}{ds_radf}(object, trunc = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{ds_radf}. The output of \code{\link{datestamp}}}

\item{trunc}{Whether to remove the period of the minimum window from the plot (default = TRUE).}

\item{...}{Further arguments passed to methods. Not used.}
}
\value{
\link[ggplot2]{ggplot}
}
\description{
Takes a \code{ds_radf} object and returns a ggplot2 object, with a
\link[ggplot2]{geom_segment} layer.
}
\examples{
\donttest{

sim_data_wdate \%>\%
  radf() \%>\%
  datestamp() \%>\%
  autoplot()

# Change the colour manually
sim_data_wdate \%>\%
  radf() \%>\%
  datestamp() \%>\%
  autoplot() +
  ggplot2::scale_colour_manual(values = rep("black", 4))
}
}
