% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-zip-gallery.R
\name{create_epoch_images_zip}
\alias{create_epoch_images_zip}
\title{Create zip file from epoch images}
\usage{
create_epoch_images_zip(
  epochs_to_save,
  epoch_index,
  block_name,
  run_dir_num,
  epochs_out,
  pupil_steps,
  eyeris_object,
  eye_suffix = NULL,
  report_epoch_grouping_var_col = "matched_event",
  verbose = FALSE
)
}
\arguments{
\item{epochs_to_save}{List of epoch data to save}

\item{epoch_index}{Index of the current epoch being processed}

\item{block_name}{Name of the current block being processed}

\item{run_dir_num}{Run directory number}

\item{epochs_out}{Output directory for the epoch files}

\item{pupil_steps}{Vector of pupil processing steps}

\item{eyeris_object}{The full \code{eyeris} object (needed for screen dimensions)}

\item{eye_suffix}{Optional eye suffix for binocular data}

\item{report_epoch_grouping_var_col}{Column name for grouping epochs}

\item{verbose}{Whether to print verbose output}
}
\value{
Path to the created zip file
}
\description{
Creates a zip file containing epoch images instead of saving individual files.
This function collects all the image data in memory and then creates a single
zip file, which can be more efficient for the HTML gallery display.
}
\keyword{internal}
