% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ez_latitude_plot.R
\name{ez_latitude_plot}
\alias{ez_latitude_plot}
\title{Plot Latitude Over Time}
\usage{
ez_latitude_plot(
  data,
  color_palette = "turbo",
  facet = FALSE,
  date_format = NULL,
  date_breaks = NULL,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{data}{A data frame or `sf` object with columns `id`, `timestamp`, and `y` (latitude).}

\item{color_palette}{Character. Viridis palette option: "viridis", "magma", "plasma", "inferno", "cividis", or "turbo". Default is "turbo".}

\item{facet}{Logical. If TRUE, creates a separate facet panel for each animal. Default is FALSE.}

\item{date_format}{Optional. Format for date labels on the x-axis (e.g., "\%b \%d", "\%Y-\%m", "\%H:\%M"). Default is automatic.}

\item{date_breaks}{Optional. Interval for x-axis breaks (e.g., "1 day", "2 weeks"). Default is automatic.}

\item{start_date}{Optional. A `Date` object or string (e.g., "2023-01-01"). Filters out data before this date.}

\item{end_date}{Optional. A `Date` object or string (e.g., "2023-02-01"). Filters out data after this date.}
}
\value{
A ggplot object.
}
\description{
Creates a time series plot of latitude (y-axis) over timestamp (x-axis), with separate lines for each individual animal. Optionally facets the plot by animal and allows customization of x-axis date format and break spacing.
}
