% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_quantiles.R
\name{tidy_quantiles}
\alias{tidy_quantiles}
\title{Fast grouped sample quantiles}
\usage{
tidy_quantiles(
  data,
  ...,
  probs = seq(0, 1, 0.25),
  type = 7,
  pivot = c("long", "wide"),
  na.rm = TRUE,
  .by = NULL,
  .cols = NULL,
  .order = group_by_order_default(data),
  .drop_groups = deprecated()
)
}
\arguments{
\item{data}{A data frame.}

\item{...}{\verb{<data-masking>} Variables to calculate quantiles for.}

\item{probs}{\code{numeric(n)} - Quantile probabilities.}

\item{type}{\code{integer(1)} - Quantile type, see \code{?collapse::fquantile}}

\item{pivot}{\code{character(1)} - Pivot result wide or long? Default is "wide".}

\item{na.rm}{\code{logical(1)} Should \code{NA} values be ignored? Default is \code{TRUE}.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{.order}{Should the groups be returned in sorted order?
If \code{FALSE}, this will return the groups in order of first appearance,
and in many cases is faster.}

\item{.drop_groups}{\code{lifecycle::badge("deprecated")}}
}
\value{
A data frame of sample quantiles.
}
\description{
Fast grouped sample quantiles
}
\examples{
library(fastplyr)
library(dplyr)
groups <- 1 * 2^(0:10)

# Normal distributed samples by group using the group value as the mean
# and sqrt(groups) as the sd

samples <- tibble(groups) |>
  reframe(x = rnorm(100, mean = groups, sd = sqrt(groups)), .by = groups) |>
  f_group_by(groups)

# Fast means and quantiles by group

quantiles <- samples |>
  tidy_quantiles(x, pivot = "wide")

means <- samples |>
  f_summarise(mean = mean(x))

means |>
  f_left_join(quantiles)
}
